/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.PrimitiveTypes;

public abstract class DispatchLog {
    private static boolean enabled = false;
    private static final Log LOG = Log.get(DispatchLog.class);
    private static final ConfigurationEventListener LISTENER = new ConfigurationEventListener(){

        public void configurationRemoved(String name) {
        }

        public void configurationChanged(String name, Configuration newConf) {
            enabled = (Boolean)PrimitiveTypes.valueOf((String)newConf.get("debug.debugger", "false"), Boolean.class);
        }
    };

    public static boolean isEnabled() {
        return enabled;
    }

    public static void log(CharSequence msg) {
        if (DispatchLog.isEnabled()) {
            LOG.info(((Object)msg).toString());
        }
    }

    public static void log(Throwable t) {
        if (DispatchLog.isEnabled()) {
            LOG.info(t);
        }
    }

    public static void setup() {
        ConfigurationsProvider.INSTANCE.addListener("defaults", LISTENER);
    }

    public static void teardown() {
        ConfigurationsProvider.INSTANCE.removeListener(LISTENER);
    }
}

