/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.web.Cookie;

class CookieWrapper
implements Cookie {
    private final javax.servlet.http.Cookie cookie;

    public CookieWrapper(javax.servlet.http.Cookie cookie) {
        this.cookie = cookie;
    }

    @Override
    public String comment() {
        return this.cookie.getComment();
    }

    @Override
    public String domain() {
        return this.cookie.getDomain();
    }

    @Override
    public int maxAge() {
        return this.cookie.getMaxAge();
    }

    @Override
    public String name() {
        return this.cookie.getName();
    }

    @Override
    public String path() {
        return this.cookie.getPath();
    }

    @Override
    public boolean secure() {
        return this.cookie.getSecure();
    }

    private String maxAgeText() {
        int maxAge = this.maxAge();
        if (maxAge < 0) {
            return null;
        }
        return Integer.toString(maxAge);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.name());
        b.append("=");
        b.append(this.value());
        this.parameter(b, "Domain", this.domain());
        this.parameter(b, "Path", this.path());
        this.parameter(b, "Max-Age", this.maxAgeText());
        this.parameter(b, "Secure", this.secure());
        this.parameter(b, "HttpOnly", true);
        return b.toString();
    }

    private void parameter(StringBuilder b, String paramName, boolean paramValue) {
        if (paramValue) {
            b.append("; ");
            b.append(paramName);
        }
    }

    private void parameter(StringBuilder b, String paramName, String paramValue) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)paramValue)) {
            b.append("; ");
            b.append(paramValue);
        }
    }

    @Override
    public String value() {
        return this.cookie.getValue();
    }

    @Override
    public int version() {
        return this.cookie.getVersion();
    }

    javax.servlet.http.Cookie cookie() {
        return this.cookie;
    }
}

