/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.uri;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.rt.uri.HasURITemplate;

public abstract class URITemplates {
    private URITemplates() {
    }

    public static <T extends HasURITemplate> Set<T> choose(Iterable<T> candidates, String path) {
        return URITemplates.choose(candidates.iterator(), path);
    }

    public static <T extends HasURITemplate> Set<T> choose(Iterator<T> candidates, String path) {
        TreeSet<HasURITemplate> ordered = new TreeSet<HasURITemplate>(HasURITemplate.COMPARATOR);
        MatchingTemplate matches = new MatchingTemplate(path);
        Iterators.add(ordered, (Iterator)Iterators.select(candidates, matches));
        return ordered;
    }

    private static final class MatchingTemplate<T extends HasURITemplate>
    implements Selector<T> {
        private final String path;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchingTemplate [path=");
            builder.append(this.path);
            builder.append("]");
            return builder.toString();
        }

        private MatchingTemplate(String path) {
            this.path = path;
        }

        public Boolean apply(T x) {
            boolean matches = x.uriTemplate().matches(this.path);
            return matches;
        }
    }
}

