/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.tenants;

import java.util.Iterator;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.TenantsProvider;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public abstract class Tenants {
    private Tenants() {
    }

    public static RequestEntity tenant(RequestEntity request, String tenantIdentifier) {
        Iterable tenantProviders = ServiceLocator.acquireAll(TenantsProvider.class, (String[])new String[0]);
        return Tenants.tenant(request, tenantIdentifier, (Iterable<TenantsProvider>)tenantProviders);
    }

    static RequestEntity tenant(RequestEntity request, String tenantIdentifier, Iterable<TenantsProvider> tenantProviders) {
        CompoundPrincipal principal = request.principal();
        TenantPrincipal tenant = Tenants.tenant(principal, tenantIdentifier, tenantProviders);
        return Requests.replacePrincipal(request, tenant, TenantPrincipal.class);
    }

    static TenantPrincipal tenant(CompoundPrincipal principal, String tenantIdentifier, Iterable<TenantsProvider> tenantProviders) {
        TenantsProvider provider;
        if (tenantIdentifier == null) {
            return TenantPrincipal.noTenant();
        }
        long id = -1L;
        Iterator<TenantsProvider> i$ = tenantProviders.iterator();
        while (i$.hasNext() && (id = (provider = i$.next()).tenant(principal, tenantIdentifier)) == -1L) {
        }
        if (id == -1L) {
            throw WebException.notFound();
        }
        return TenantPrincipal.tenant(tenantIdentifier, id);
    }
}

