/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.security.Principal;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCProxyPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

class ResourceTemplatesJDBCPrincipal {
    private static final String RESOURCE_TEMPLATES_POOL_SUFFIX = "_rt";

    ResourceTemplatesJDBCPrincipal() {
    }

    static RequestEntity request(RequestEntity request, String parsingSchema) {
        TenantPrincipal tenant;
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        CompoundPrincipal existingPrincipal = request.principal();
        JDBCPrincipal existing = (JDBCPrincipal)existingPrincipal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.principal(null);
        }
        if (existing == null) {
            throw WebException.serviceUnavailable();
        }
        JDBCPrincipal resourceTemplates = jdbc.principal(existing.getName() + RESOURCE_TEMPLATES_POOL_SUFFIX);
        if (resourceTemplates == null) {
            throw WebException.serviceUnavailable();
        }
        RequestEntity addedJDBCPrincipal = Requests.replacePrincipal(request, (Principal)resourceTemplates, JDBCPrincipal.class);
        if (parsingSchema == null && (tenant = (TenantPrincipal)existingPrincipal.principal(TenantPrincipal.class)) != null) {
            parsingSchema = tenant.getName();
        }
        if (parsingSchema == null) {
            return addedJDBCPrincipal;
        }
        JDBCProxyPrincipal proxy = new JDBCProxyPrincipal(parsingSchema);
        return Requests.replacePrincipal(addedJDBCPrincipal, (Principal)proxy, JDBCProxyPrincipal.class);
    }
}

