/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.resource.generator.ResourceRequest;
import oracle.dbtools.rt.resource.generator.ResourceRequests;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.web.RequestEntity;

public class ResourceTemplateRequest
implements ResourceRequest {
    private final ResourceHandler handler;
    private final int itemsPerPage;
    private final RequestEntity request;
    private final ResourceTemplate template;

    private ResourceTemplateRequest(ResourceTemplate template, ResourceHandler handler, RequestEntity request, int itemsPerPage) {
        this.template = template;
        this.handler = handler;
        int handlerItemsPerPage = handler.itemsPerPage();
        this.itemsPerPage = handlerItemsPerPage > 0 ? handlerItemsPerPage : itemsPerPage;
        this.request = request;
    }

    @Override
    public String content() {
        return this.handler.content();
    }

    @Override
    public Iterable<ResourceParameter> explicitParameters() {
        return Iterables.iterable((Object[])this.handler.parameters());
    }

    @Override
    public Iterable<String> implicitParameters() {
        return this.template.implicitParameterNames(this.handler);
    }

    @Override
    public Map<String, Object> inboundValues() {
        return this.template.inboundValues(this.handler, this.itemsPerPage, this.request.path(), this.request.headers());
    }

    @Override
    public Pair<EntityHeaders, Map<String, Object>> outboundValues(Map<String, Object> results) {
        return ResourceRequests.outboundValues(this, results);
    }

    @Override
    public String[] preferredContentType() {
        EntityHeader preferred = this.request.headers().header("X-APEX-PREFERRED-CONTENT-TYPE");
        if (preferred == null) {
            return null;
        }
        ArrayList values = new ArrayList();
        Iterables.add(values, preferred.values());
        return values.toArray(new String[values.size()]);
    }

    @Override
    public RequestEntity request() {
        return this.request;
    }

    static ResourceRequest adapt(ResourceTemplate template, ResourceHandler handler, int itemsPerPage, RequestEntity request) {
        if (handler == null) {
            return null;
        }
        return new ResourceTemplateRequest(template, handler, request, itemsPerPage);
    }
}

