/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.model.Persistent;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Persistent
public class ResourceParameter {
    private ParameterAccess access;
    private String aliasing;
    private Kind kind;
    private String name;
    private String primitiveType;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceParameter [name=");
        builder.append(this.name);
        builder.append(", aliasing=");
        builder.append(this.aliasing);
        builder.append(", kind=");
        builder.append((Object)this.kind);
        builder.append(", access=");
        builder.append(this.access);
        builder.append(", primitiveType=");
        builder.append(this.primitiveType);
        builder.append("]");
        return builder.toString();
    }

    public ResourceParameter(Kind type, String name, String aliasing, Class<?> classOf, ParameterAccess access) {
        this.kind = type;
        this.name = name;
        this.aliasing = aliasing;
        this.primitiveType = classOf.getName();
        this.access = access;
    }

    private ResourceParameter() {
    }

    public ParameterAccess access() {
        return this.access;
    }

    public String aliasing() {
        return this.aliasing == null ? this.name : this.aliasing;
    }

    public Kind kind() {
        return this.kind;
    }

    public String name() {
        return this.name;
    }

    public Class<?> primitiveType() {
        try {
            return Class.forName(this.primitiveType);
        }
        catch (ClassNotFoundException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public static enum Kind {
        HEADER,
        URI;

    }
}

