/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.ItemResultRow;
import oracle.dbtools.rt.resource.collection.tenants.GetMultiTenantCollectionResource;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;

@Service(provides={RequestDispatcher.class})
public class GetResourceModules
extends GetMultiTenantCollectionResource {
    @Reference
    private ResourceModules modules;
    private static ContentType CONTENT_TYPE = ContentType.contentType("application/vnd.oracle.apex+xml");

    public GetResourceModules() {
        super(ResourceTemplatesProfile.URI_TEMPLATES, CONTENT_TYPE);
    }

    @Override
    protected Iterator<FeedItem> items(RequestEntity request) {
        return Iterators.transform(this.modules.entities(null, request.principal()).iterator(), (Transform)new Transform<ResourceModule, FeedItem>(){

            public FeedItem apply(final ResourceModule module) {
                return new FeedItem(){

                    @Override
                    public ContentType contentType() {
                        return CONTENT_TYPE;
                    }

                    @Override
                    public String id() {
                        return EntityIds.string(module.id());
                    }

                    @Override
                    public ResultRow item() {
                        return new ItemResultRow(new String[]{"title"}, new String[]{module.name()});
                    }
                };
            }
        });
    }
}

