/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.ZipBuilder;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;

@Service(provides={RequestDispatcher.class})
public class ExportResourceModules
extends RequestHandler {
    @Reference
    private ResourceModules modules;
    public static final String PATH = ResourceTemplatesProfile.URI_TEMPLATES.collection().encode(new String[0]) + "exports.zip";
    static final URITemplate URI_TEMPLATE = new URITemplate(PATH);
    private static final String FILE_EXTENSION = ".ortx";

    public ExportResourceModules() {
        super(HttpMethod.GET, SECURE_RESOURCE_TEMPLATE, URI_TEMPLATE, false);
    }

    @Override
    public HttpResource dispatch(final RequestEntity request) throws IOException {
        return new HttpResource(){

            @Override
            public String version() {
                return null;
            }

            @Override
            public Entity response() throws IOException {
                InputStream zipStream = ExportResourceModules.this.compressedResourceModules(request.principal());
                return Entities.entity(zipStream, Entities.headers(HttpHeader.CONTENT_TYPE, ContentTypes.ZIP, "Content-Disposition", "attachment; filename=resources.zip"));
            }
        };
    }

    private InputStream cdata(InputStream content) throws IOException {
        X3PReader r = X3PFactory.newReader((InputStream)content);
        return X3PFactory.newStream((X3PReader)r, (X3PWriterOptions)ResourceTemplatesProfile.DEFAULT_SERIALIZATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream compressedResourceModules(CompoundPrincipal principal) throws IOException {
        ZipBuilder zip = ZipBuilder.builder();
        Iterable<ResourceModule> resourceModules = null;
        try {
            resourceModules = this.modules.entities(null, principal);
            for (ResourceModule module : resourceModules) {
                String name = this.name(module);
                zip.addEntry(name, this.cdata(module.content()));
            }
        }
        finally {
            Closeables.close(resourceModules);
        }
        return zip.build();
    }

    private String name(ResourceModule module) {
        String name = module.name() + FILE_EXTENSION;
        return name;
    }
}

