/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.net.URI;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.resource.collection.CollectionResource;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.ItemResultRow;
import oracle.dbtools.rt.uri.URITemplate;

public class FeedItemTransform
implements CollectionResource<FeedItem> {
    private final URI base;
    private final URITemplate itemTemplate;
    private static final String DEFAULT_ITEM_REL = "edit http://apex.oracle.com/item";

    public FeedItemTransform(URITemplate itemTemplate, String base) {
        this.base = URIs.create((String)base);
        this.itemTemplate = itemTemplate;
    }

    public ResultRow apply(FeedItem item) {
        return new FeedItemRow(item);
    }

    private String location(URITemplate uriTemplate, String id) {
        return uriTemplate.encode(new String[]{"id", id});
    }

    private static String absoluteLocation(URI base, String path) {
        return URIs.resolve((URI)base, (String)path).toString();
    }

    private class FeedItemRow
    extends ItemResultRow {
        public FeedItemRow(FeedItem item) {
            super(CollectionResource.NAMES, new Object[]{FeedItemTransform.DEFAULT_ITEM_REL, FeedItemTransform.absoluteLocation(FeedItemTransform.this.base, FeedItemTransform.this.location(FeedItemTransform.this.itemTemplate, item.id())), item.contentType().mediaType(), item.item()});
        }
    }
}

