/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.plsql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.apex.OWA;
import oracle.dbtools.apex.Version;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCProxyPrincipal;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

class OracleWebAccess {
    private final JDBCCallProvider jdbc;
    static final String DOWNLOAD_BFILE_SQL = "declare l_bfile bfile; begin wpg_docload.get_download_bfile(p_bfile=>l_bfile); dbms_lob.fileopen(l_bfile); :content := l_bfile; end;";
    static final Statement DOWNLOAD_BFILE_STMT = StatementBuilder.call().append((CharSequence)"declare l_bfile bfile; begin wpg_docload.get_download_bfile(p_bfile=>l_bfile); dbms_lob.fileopen(l_bfile); :content := l_bfile; end;").parameter("content", InputStream.class, ParameterAccess.OUT).build();
    static final String DOWNLOAD_BLOB_SQL = "begin wpg_docload.get_download_blob(p_blob=>:content); end;";
    static final Statement DOWNLOAD_BLOB_STMT = StatementBuilder.call().append((CharSequence)"begin wpg_docload.get_download_blob(p_blob=>:content); end;").parameter("content", InputStream.class, ParameterAccess.OUT).build();
    static final String GET_PAGE_SQL = "declare \n   nlns        number := 999999;\n   l_clob      CLOB;\n   lines       htp.htbuf_arr;\n   l_buff      varchar2(32767);\n   l_clob_init boolean:= false;\n   l_file      varchar2(5);\n   l_doc_info  varchar2(1000);\n begin\n    OWA.GET_PAGE(lines, nlns);\n   if (nlns > 1) then\n    for i in 1..nlns loop\n       if ( length(lines(i)) > 0 ) then \n          if (  ( lengthb(l_buff) + lengthb(lines(i)))  > 32767) then \n        if (NOT l_clob_init) then\n          dbms_lob.createtemporary(l_clob, TRUE); \n          dbms_lob.open(l_clob, dbms_lob.lob_readwrite);\n        l_clob_init:=true;\n       end if;\n              dbms_lob.writeappend(l_clob,length(l_buff),l_buff);\n               l_buff := lines(i);\n          else\n              l_buff := l_buff || lines(i);\n          end if;\n       end if; \n    end loop;\n   end if;\n   if (l_clob_init) then\n      dbms_lob.writeappend(l_clob,length(l_buff),l_buff); \n      l_buff := ''; \n   end if; \n   :lob := l_clob;\n   :text := l_buff;\n   if (wpg_docload.is_file_download) then\n     l_file:='TRUE';\n     wpg_docload.get_download_file(l_doc_info);\n   else l_file := 'FALSE';\n   end if;\n   :is_file := l_file;\n   :doc_info := l_doc_info;\n end;";
    static final Statement GET_PAGE_STMT = StatementBuilder.call().append((CharSequence)"declare \n   nlns        number := 999999;\n   l_clob      CLOB;\n   lines       htp.htbuf_arr;\n   l_buff      varchar2(32767);\n   l_clob_init boolean:= false;\n   l_file      varchar2(5);\n   l_doc_info  varchar2(1000);\n begin\n    OWA.GET_PAGE(lines, nlns);\n   if (nlns > 1) then\n    for i in 1..nlns loop\n       if ( length(lines(i)) > 0 ) then \n          if (  ( lengthb(l_buff) + lengthb(lines(i)))  > 32767) then \n        if (NOT l_clob_init) then\n          dbms_lob.createtemporary(l_clob, TRUE); \n          dbms_lob.open(l_clob, dbms_lob.lob_readwrite);\n        l_clob_init:=true;\n       end if;\n              dbms_lob.writeappend(l_clob,length(l_buff),l_buff);\n               l_buff := lines(i);\n          else\n              l_buff := l_buff || lines(i);\n          end if;\n       end if; \n    end loop;\n   end if;\n   if (l_clob_init) then\n      dbms_lob.writeappend(l_clob,length(l_buff),l_buff); \n      l_buff := ''; \n   end if; \n   :lob := l_clob;\n   :text := l_buff;\n   if (wpg_docload.is_file_download) then\n     l_file:='TRUE';\n     wpg_docload.get_download_file(l_doc_info);\n   else l_file := 'FALSE';\n   end if;\n   :is_file := l_file;\n   :doc_info := l_doc_info;\n end;").parameter("lob", Reader.class, ParameterAccess.OUT).parameter("text", String.class, ParameterAccess.OUT).parameter("is_file", String.class, ParameterAccess.OUT).parameter("doc_info", String.class, ParameterAccess.OUT).build();
    static final String INIT_SQL = " declare   nm  owa.vc_arr := :header_names;   \n  vl  owa.vc_arr := :header_values;   \n begin  \n   owa.init_cgi_env( :num_headers, nm, vl ); \n   htp.init;   htp.HTBUF_LEN := 63;\n  end;";
    static final Statement INIT_STMT = StatementBuilder.call().append((CharSequence)" declare   nm  owa.vc_arr := :header_names;   \n  vl  owa.vc_arr := :header_values;   \n begin  \n   owa.init_cgi_env( :num_headers, nm, vl ); \n   htp.init;   htp.HTBUF_LEN := 63;\n  end;").parameter("num_headers", Integer.class, ParameterAccess.IN).parameter("header_names", String[].class, ParameterAccess.IN).parameter("header_values", String[].class, ParameterAccess.IN).build();
    static final String RESET_SQL = " begin dbms_session.modify_package_state(dbms_session.reinitialize); end;";
    static final Statement RESET_STMT = StatementBuilder.call().append((CharSequence)" begin dbms_session.modify_package_state(dbms_session.reinitialize); end;").build();

    OracleWebAccess(JDBCCallProvider jdbc) {
        this.jdbc = jdbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Transaction txn, RequestEntity request) throws SQLException {
        JDBCCall init = null;
        try {
            init = this.jdbc.call(txn, INIT_STMT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            OWA.Headers hdrs = this.getHeaders(request);
            parameters.put("num_headers", hdrs.getSize());
            parameters.put("header_names", hdrs.getNames());
            parameters.put("header_values", hdrs.getValues());
            init.bind(parameters);
            init.execute();
        }
        catch (Throwable throwable) {
            Closeables.close(init);
            throw throwable;
        }
        Closeables.close((Object)init);
    }

    public Entity response(Transaction txn) throws SQLException {
        Entity entity;
        JDBCCall page = null;
        try {
            page = this.jdbc.call(txn, GET_PAGE_STMT);
            page.bind(Collections.EMPTY_MAP);
            Map results = page.execute();
            InputStream content = (InputStream)results.get("lob");
            if (content == null) {
                content = StreamCopy.toInputStream((String)((String)results.get("text")));
            }
            EntityHeaders headers = OracleWebAccess.consumeHeaders(content);
            InputStream body = content;
            boolean isFile = Boolean.parseBoolean((String)results.get("is_file"));
            if (isFile) {
                String docInfo = (String)results.get("doc_info");
                body = OracleWebAccess.download(this.jdbc, txn, docInfo);
            }
            entity = Entities.entity(body, headers);
        }
        catch (IOException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(page);
                throw throwable;
            }
        }
        Closeables.close((Object)page);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Transaction txn) {
        JDBCCall reset = null;
        try {
            try {
                reset = this.jdbc.call(txn, RESET_STMT);
            }
            catch (SQLException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(reset);
            throw throwable;
        }
        Closeables.close((Object)reset);
    }

    static EntityHeaders consumeHeaders(InputStream content) {
        return Entities.headers(OracleWebAccess.headers(content));
    }

    private static InputStream download(JDBCCallProvider jdbc, Transaction txn, Statement stmt) throws SQLException {
        JDBCCall download = jdbc.call(txn, stmt);
        download.bind(Collections.emptyMap());
        Map results = download.execute();
        InputStream content = (InputStream)results.get("content");
        return Closeables.alsoClose((InputStream)content, (Object[])new Object[]{download});
    }

    static InputStream download(JDBCCallProvider jdbc, Transaction txn, String docInfo) throws SQLException, IOException {
        if (docInfo.equals("B")) {
            return OracleWebAccess.download(jdbc, txn, DOWNLOAD_BLOB_STMT);
        }
        if (docInfo.equals("F")) {
            return OracleWebAccess.download(jdbc, txn, DOWNLOAD_BFILE_STMT);
        }
        throw new IllegalArgumentException("docInfo type not understood" + docInfo);
    }

    private OWA.Headers getHeaders(RequestEntity request) {
        URI uri = URIs.create((String)(request.base() + request.path()));
        String path = URIs.path((URI)uri);
        OWA.Headers _header = new OWA.Headers();
        EntityHeaders hdrs = request.headers();
        for (String name : hdrs) {
            EntityHeader hdr = hdrs.header(name);
            for (String value : hdr.values()) {
                _header.addHeader(name, value);
            }
        }
        _header.addHeader("APEX_LISTENER_VERSION", Version.INSTANCE.getVersion());
        _header.addHeader("DAD_NAME", "");
        _header.addHeader("DOC_ACCESS_PATH", "");
        _header.addHeader("DOCUMENT_TABLE", "");
        _header.addHeader("GATEWAY_IVERSION", "3");
        _header.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        _header.addHeader("HTTP_ACCEPT", OracleWebAccess.value(hdrs, "accept"));
        _header.addHeader("HTTP_ACCEPT_ENCODING", OracleWebAccess.value(hdrs, "accept-encoding"));
        _header.addHeader("HTTP_ACCEPT_LANGUAGE", OracleWebAccess.value(hdrs, "accept-language"));
        _header.addHeader("HTTP_ACCEPT_CHARSET", OracleWebAccess.value(hdrs, "accept-charset"));
        _header.addHeader("HTTP_COOKIE", OracleWebAccess.value(hdrs, "cookie"));
        _header.addHeader("HTTP_IF_MODIFIED_SINCE", OracleWebAccess.value(hdrs, "if-modified-since"));
        _header.addHeader("HTTP_IF_NONE_MATCH", OracleWebAccess.value(hdrs, "if-none-match"));
        if (Requests.isStandardPort(request)) {
            _header.addHeader("HTTP_HOST", uri.getHost());
        } else {
            _header.addHeader("HTTP_HOST", uri.getHost() + ":" + uri.getPort());
        }
        _header.addHeader("HTTP_ORACLE_ECID", "");
        _header.addHeader("HTTP_PORT", uri.getPort() + "");
        _header.addHeader("HTTP_REFERER", OracleWebAccess.value(hdrs, "referer"));
        _header.addHeader("HTTP_USER_AGENT", OracleWebAccess.value(hdrs, "user-agent"));
        _header.addHeader("PATH_ALIAS", " ");
        _header.addHeader("PATH_INFO", path.substring(path.lastIndexOf("/")));
        _header.addHeader("PLSQL_GATEWAY", "WebDb");
        _header.addHeader("QUERY_STRING", uri.getQuery());
        _header.addHeader("REMOTE_ADDR", OracleWebAccess.value(hdrs, "X-APEX-REMOTE-ADDRESS"));
        String remoteUser = OracleWebAccess.remoteUser(request);
        _header.addHeader("REMOTE_USER", remoteUser);
        _header.addHeader("REQUEST_CHARSET", "AL32UTF8");
        _header.addHeader("REQUEST_IANA_CHARSET", Text.defaultEncoding());
        _header.addHeader("REQUEST_METHOD", request.method());
        _header.addHeader("REQUEST_PROTOCOL", uri.getScheme());
        _header.addHeader("REQUEST_SCHEME", uri.getScheme());
        _header.addHeader("SCRIPT_NAME", path.substring(0, path.lastIndexOf("/")));
        _header.addHeader("SCRIPT_PREFIX", "");
        _header.addHeader("SERVER_NAME", uri.getHost());
        _header.addHeader("SERVER_PORT", uri.getPort() + "");
        _header.addHeader("SERVER_PROTOCOL", "1.1");
        _header.addHeader("SERVER_SOFTWARE", "Resource-Templates");
        _header.addHeader("WEB_AUTHENT_PREFIX", " ");
        return _header;
    }

    protected static String remoteUser(RequestEntity request) {
        String remoteUser = Requests.remoteUser(request);
        String jdbcProxyUser = JDBCProxyPrincipal.jdbcProxyUser((CompoundPrincipal)request.principal());
        String jdbcUser = OracleWebAccess.jdbcUserName(request.principal());
        if (remoteUser == null) {
            remoteUser = jdbcProxyUser == null ? jdbcUser : jdbcProxyUser;
        }
        return remoteUser;
    }

    private static String jdbcUserName(CompoundPrincipal principal) {
        JDBCPrincipal jdbc = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (jdbc == null) {
            return null;
        }
        return jdbc.getName();
    }

    private static Iterator<EntityHeader> headers(final InputStream content) {
        if (null == content) {
            throw new NullPointerException();
        }
        return new AbstractIterator<EntityHeader>(){
            private boolean finished = false;

            protected EntityHeader advance() {
                EntityHeader header = null;
                if (!this.finished) {
                    while (header == null) {
                        String line = this.nextLine();
                        if (line.isEmpty()) {
                            this.finished = true;
                            return null;
                        }
                        int delimiter = line.indexOf(58);
                        if (delimiter == -1) continue;
                        header = Entities.header(line.substring(0, delimiter), line.substring(delimiter + 1));
                    }
                }
                return header;
            }

            private String nextLine() {
                try {
                    StringBuilder line = new StringBuilder();
                    boolean eol = false;
                    int data = content.read();
                    while (!eol) {
                        if (-1 == data || 10 == data) {
                            eol = true;
                            continue;
                        }
                        line.append((char)data);
                        data = content.read();
                    }
                    return line.toString().trim();
                }
                catch (IOException e) {
                    throw WebException.internalError(e, new Reason[0]);
                }
            }
        };
    }

    private static String value(EntityHeaders hdrs, String name) {
        EntityHeader hdr = hdrs.header(name);
        if (hdr != null) {
            return hdr.value();
        }
        return null;
    }
}

