/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.scope;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.rt.home.EntityMetaData;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.resource.collection.ItemResultRow;

@Entity
public class Scope
implements MultiTenantEntity {
    private String description;
    @PrimaryKey
    private MultiTenantEntityPK id;
    private final EntityMetaData metadata = new EntityMetaData();
    @SecondaryKey(relate=Relationship.ONE_TO_MANY)
    private Set<MultiTenantEntityPK> modules = new HashSet<MultiTenantEntityPK>();
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    private String name;
    private String title;
    private String requiredRole;
    private static String[] FIELDS = new String[]{"description", "name", "requiredRole", "modules"};

    public InputStream content() {
        Long[] modules = new Long[this.modules.size()];
        int i = 0;
        for (MultiTenantEntityPK id : this.modules) {
            modules[i] = id.entityId();
            ++i;
        }
        ItemResultRow row = new ItemResultRow(FIELDS, new Object[]{this.description, this.name, this.requiredRole, modules});
        return new JSONQueryStream(Iterators.iterator((Object[])new ResultRow[]{row}), true, null);
    }

    public String description() {
        return this.description;
    }

    public Scope description(String description) {
        this.description = description;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scope other = (Scope)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public MultiTenantEntityPK id() {
        return this.id;
    }

    @Override
    public void id(MultiTenantEntityPK id) {
        this.id = id;
        HashSet<MultiTenantEntityPK> scopedIds = new HashSet<MultiTenantEntityPK>();
        for (MultiTenantEntityPK moduleId : this.modules) {
            scopedIds.add(MultiTenantEntityPK.key(id.tenantId(), moduleId.entityId()));
        }
        this.modules.clear();
        this.modules = scopedIds;
    }

    @Override
    public EntityMetaData metadata() {
        return this.metadata;
    }

    public Scope module(long moduleId) {
        long tenantId = -2L;
        if (this.id != null) {
            tenantId = this.id.tenantId();
        }
        this.modules.add(MultiTenantEntityPK.key(tenantId, moduleId));
        return this;
    }

    public String name() {
        return this.name;
    }

    public Scope name(String name) {
        this.name = name;
        return this;
    }

    public String requiredRole() {
        return this.requiredRole;
    }

    public Scope requiredRole(String requiredRole) {
        this.requiredRole = requiredRole;
        return this;
    }

    @Override
    public MultiTenantEntityPK parentId() {
        return MultiTenantEntityPK.NO_PARENT;
    }

    @Override
    public void parentId(MultiTenantEntityPK templateId) {
    }

    public String title() {
        return this.title;
    }

    public Scope title(String title) {
        this.title = title;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Scope [description=");
        builder.append(this.description);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", metadata=");
        builder.append(this.metadata);
        builder.append(", modules=");
        builder.append(this.modules);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", requiredRole=");
        builder.append(this.requiredRole);
        builder.append("]");
        return builder.toString();
    }
}

