/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.scope;

import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.Scopes;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.ItemResultRow;
import oracle.dbtools.rt.resource.collection.tenants.GetMultiTenantCollectionResource;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;

@Service(provides={RequestDispatcher.class})
public class GetScopes
extends GetMultiTenantCollectionResource {
    @Reference
    private Scopes scopes;
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";

    public GetScopes() {
        super(OAuthProfile.SCOPE_URI_TEMPLATES, OAuthProfile.OAUTH_SCOPE_JSON);
    }

    @Override
    protected Iterator<FeedItem> items(RequestEntity request) {
        Iterable<Scope> scopes = this.scopes.entities(null, request.principal());
        Iterable items = Iterables.transform(scopes, (Transform)new Transform<Scope, FeedItem>(){

            public FeedItem apply(final Scope scope) {
                return new FeedItem(){

                    @Override
                    public ContentType contentType() {
                        return OAuthProfile.OAUTH_CLIENT_JSON;
                    }

                    @Override
                    public String id() {
                        return EntityIds.string(scope.id());
                    }

                    @Override
                    public ResultRow item() {
                        return new ItemResultRow(new String[]{GetScopes.ID, GetScopes.TITLE, GetScopes.NAME, GetScopes.DESCRIPTION}, new Object[]{PrimitiveTypes.string((Object)scope.id().entityId()), scope.title(), scope.name(), scope.description()});
                    }
                };
            }
        });
        return Iterators.alsoClose(items.iterator(), (Object[])new Object[]{scopes});
    }
}

