/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.jdbc;

import java.security.Principal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.jdbc.RowToScopeEntity;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.ScopesProvider;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

@Service(priority=1)
public class JDBCScopesProvider
implements ScopesProvider {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private QueryProvider query;
    private static final String _SCOPE_SELECT = "select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s ";
    private static final RowToScopeEntity ROW_TO_SCOPE = new RowToScopeEntity();
    private static final String SCOPE_BY_TENANT = "select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s where s.security_group_id = :tenant_id order by s.label";
    private static final Statement SCOPE_BY_TENANT_STMT = StatementBuilder.query().append((CharSequence)"select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s where s.security_group_id = :tenant_id order by s.label").parameter("tenant_id", Long.class, ParameterAccess.IN).build();
    private static final String SCOPE_BY_ID = "select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s where s.id = :id";
    private static final Statement SCOPE_BY_ID_STMT = StatementBuilder.query().append((CharSequence)"select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s where s.id = :id").parameter("id", Long.class, ParameterAccess.IN).build();
    private static final String SCOPE_BY_NAME = "select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s where s.name = :name";
    private static final Statement SCOPE_BY_NAME_STMT = StatementBuilder.query((String)"select  s.id, s.security_group_id,s.name, s.label, s.description  from wwv_flow_rt$privileges s where s.name = :name", (String[])new String[]{"name"});

    @Override
    public Iterable<MultiTenantEntityPK> childIds(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        return Collections.emptyList();
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Scope> entities(Transaction txn, CompoundPrincipal principal) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        long tenantId = TenantPrincipal.id(tenant);
        parameters.put("tenant_id", tenantId);
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        Iterator<ResultRow> matches = null;
        try {
            matches = this.query(ApexListenerJDBCPrincipal.apexListener(principal), SCOPE_BY_TENANT_STMT, parameters);
            Iterators.add(scopes, (Iterator)Iterators.transform(matches, (Transform)ROW_TO_SCOPE));
        }
        catch (ConnectionPoolException e) {
            Collections.emptyList();
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    @Override
    public Scope entity(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        try {
            return this.scope(ApexListenerJDBCPrincipal.apexListener(principal), SCOPE_BY_ID_STMT, "id", entityId.entityId());
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public Scope exists(Transaction txn, CompoundPrincipal principal, Scope instance) {
        try {
            return this.scope(ApexListenerJDBCPrincipal.apexListener(principal), SCOPE_BY_NAME_STMT, "name", instance.name());
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        try {
            return this.jdbc.transaction((Principal)principal);
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
    }

    @Override
    public Scope store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, Scope instance) {
        throw new UnsupportedOperationException();
    }

    private Iterator<ResultRow> query(JDBCPrincipal apexListener, Statement stmt, Map<String, Object> parameters) {
        return this.query.query((Principal)apexListener, stmt, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scope scope(JDBCPrincipal apexListener, Statement stmt, String column, Object expected) {
        Scope existing = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(column, expected);
        Iterator<ResultRow> matches = null;
        try {
            matches = this.query(apexListener, stmt, parameters);
            existing = (Scope)Iterators.nextOrNull((Iterator)Iterators.transform(matches, (Transform)ROW_TO_SCOPE));
        }
        finally {
            Closeables.close(matches);
        }
        return existing;
    }
}

