/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.jdbc;

import java.io.Closeable;
import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientsProvider;
import oracle.dbtools.rt.oauth.jdbc.JDBCOAuthDataAccess;
import oracle.dbtools.rt.oauth.jdbc.RowToClient;
import oracle.dbtools.rt.oauth.jdbc.RowToOAuthScope;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ClientsProvider.class}, priority=1)
public class JDBCClientsProvider
implements ClientsProvider {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private QueryProvider query;
    private static final String _CLIENT_SELECT = "select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c ";
    private static final String CLIENT_BY_CLIENT_ID = "select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.client_id = :client_id";
    private static final Statement CLIENT_BY_CLIENT_ID_STMT = StatementBuilder.query((String)"select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.client_id = :client_id", (String[])new String[]{"client_id"});
    private static final String CLIENT_BY_CREATOR = "select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.created_by = upper(:created_by) order by c.name";
    private static final Statement CLIENT_BY_CREATOR_STMT = StatementBuilder.query((String)"select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.created_by = upper(:created_by) order by c.name", (String[])new String[]{"created_by"});
    private static final String CLIENT_BY_ID = "select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.id = :id";
    private static final Statement CLIENT_BY_ID_STMT = StatementBuilder.query().append((CharSequence)"select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.id = :id").parameter("id", Long.class, ParameterAccess.IN).build();
    private static final String CLIENT_BY_NAME = "select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.name = :name";
    private static final Statement CLIENT_BY_NAME_STMT = StatementBuilder.query((String)"select  c.id,c.security_group_id,c.name,c.description,c.auth_flow,c.response_type,c.client_id,c.client_secret,c.redirect_uri,c.support_email,c.created_by,c.created_on,c.updated_by,c.updated_on,c.row_version_number from wwv_flow_rt$clients c where c.name = :name", (String[])new String[]{"name"});
    private static final String CREATE_CLIENT_SCOPE = "insert into wwv_flow_rt$client_privileges (client_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:client_id,:scope_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final Statement CREATE_CLIENT_SCOPE_STMT = StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$client_privileges (client_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:client_id,:scope_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)").parameter("client_id", String.class, ParameterAccess.IN).parameter("privilege_id", Long.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("created", Timestamp.class, ParameterAccess.IN).build();
    private static final String DELETE_CLIENT = "delete from wwv_flow_rt$clients where security_group_id = :tenant_id and id = :id";
    private static final Statement DELETE_CLIENT_STMT = StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$clients where security_group_id = :tenant_id and id = :id").parameter("id", Long.class, ParameterAccess.IN).build();
    private static final String DELETE_CLIENT_SCOPE = "delete from wwv_flow_rt$client_privileges where security_group_id = :tenant_id and client_id = :client_id";
    private static final Statement DELETE_CLIENT_SCOPE_STMT = StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$client_privileges where security_group_id = :tenant_id and client_id = :client_id").parameter("client_id", Long.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).build();
    private static final String INSERT_CLIENT = "insert into wwv_flow_rt$clients (name,description,auth_flow,response_type,client_id,client_secret,redirect_uri,support_email,security_group_id,created_by,created_on,updated_by,updated_on) values (:name,:description,:auth_flow,:response_type,:client_id,:client_secret,:redirect_uri,:support_email,:tenant_id,upper(:created_by),:created,upper(:updated_by),:updated)";
    private static final Statement INSERT_CLIENT_STMT = StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$clients (name,description,auth_flow,response_type,client_id,client_secret,redirect_uri,support_email,security_group_id,created_by,created_on,updated_by,updated_on) values (:name,:description,:auth_flow,:response_type,:client_id,:client_secret,:redirect_uri,:support_email,:tenant_id,upper(:created_by),:created,upper(:updated_by),:updated)").parameter("name", String.class, ParameterAccess.IN).parameter("description", String.class, ParameterAccess.IN).parameter("auth_flow", String.class, ParameterAccess.IN).parameter("response_type", String.class, ParameterAccess.IN).parameter("client_id", String.class, ParameterAccess.IN).parameter("client_secret", String.class, ParameterAccess.IN).parameter("redirect_uri", String.class, ParameterAccess.IN).parameter("support_email", String.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("created_by", String.class, ParameterAccess.IN).parameter("created", Timestamp.class, ParameterAccess.IN).parameter("updated_by", String.class, ParameterAccess.IN).parameter("updated", Timestamp.class, ParameterAccess.IN).build();
    private static final RowToClient ROW_TO_CLIENT = new RowToClient();
    private static final String UPDATE_CLIENT = "update wwv_flow_rt$clients set name = :name,description = :description, client_id = :client_id, client_secret = :client_secret ,redirect_uri = :redirect_uri ,support_email = :support_email ,updated_by = upper(:updated_by) ,updated_on = :updated where security_group_id = :tenant_id and id = :id ";
    private static final Statement UPDATE_CLIENT_STMT = StatementBuilder.call().append((CharSequence)"update wwv_flow_rt$clients set name = :name,description = :description, client_id = :client_id, client_secret = :client_secret ,redirect_uri = :redirect_uri ,support_email = :support_email ,updated_by = upper(:updated_by) ,updated_on = :updated where security_group_id = :tenant_id and id = :id ").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("id", Long.class, ParameterAccess.IN).parameter("name", String.class, ParameterAccess.IN).parameter("description", String.class, ParameterAccess.IN).parameter("response_type", String.class, ParameterAccess.IN).parameter("client_id", String.class, ParameterAccess.IN).parameter("client_secret", String.class, ParameterAccess.IN).parameter("redirect_uri", String.class, ParameterAccess.IN).parameter("support_email", String.class, ParameterAccess.IN).parameter("updated_by", String.class, ParameterAccess.IN).parameter("updated", Timestamp.class, ParameterAccess.IN).build();

    @Override
    public Client byClientId(Transaction txn, CompoundPrincipal principal, String clientId) {
        try {
            return this.client(ApexListenerJDBCPrincipal.apexListener(principal), CLIENT_BY_CLIENT_ID_STMT, clientId, "client_id");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Client> byCreatedBy(Transaction txn, CompoundPrincipal principal) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("created_by", principal.getName());
        ArrayList<Client> clients = new ArrayList<Client>();
        Iterator<ResultRow> matches = null;
        try {
            matches = this.query(ApexListenerJDBCPrincipal.apexListener(principal), CLIENT_BY_CREATOR_STMT, parameters);
            Iterators.add(clients, (Iterator)Iterators.transform(matches, (Transform)ROW_TO_CLIENT), (boolean)false);
        }
        catch (ConnectionPoolException e) {
            List<Client> list = Collections.emptyList();
            return list;
        }
        finally {
            Closeables.close(matches);
        }
        return clients;
    }

    @Override
    public Iterable<MultiTenantEntityPK> childIds(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        return Collections.emptyList();
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        JDBCCall delete = null;
        try {
            delete = this.jdbc.call(txn, DELETE_CLIENT_STMT);
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("tenant_id", id.tenantId());
            params.put("id", id.entityId());
            delete.bind(params);
            delete.execute();
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(delete);
                throw throwable;
            }
        }
        Closeables.close((Object)delete);
    }

    @Override
    public Client entity(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        try {
            return this.client(ApexListenerJDBCPrincipal.apexListener(principal), CLIENT_BY_ID_STMT, entityId.entityId(), "id");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public Client exists(Transaction txn, CompoundPrincipal principal, Client client) {
        try {
            return this.client(ApexListenerJDBCPrincipal.apexListener(principal), CLIENT_BY_NAME_STMT, client.name(), "name");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        JDBCPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        return this.newTransaction(apexListener);
    }

    @Override
    public Client store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, Client client) {
        if (StoreMode.CREATE == storeMode) {
            return this.create(txn, client);
        }
        if (StoreMode.UPDATE == storeMode) {
            return this.update(txn, client);
        }
        throw new IllegalArgumentException("Unsupported StoreMode: " + (Object)((Object)storeMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client client(JDBCPrincipal apexListener, Statement stmt, Object expected, String column) {
        Client existing = null;
        Transaction txn = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(column, expected);
        Iterator<ResultRow> matches = null;
        try {
            txn = this.newTransaction(apexListener);
            matches = this.query(apexListener, stmt, parameters);
            existing = (Client)Iterators.nextOrNull((Iterator)Iterators.transform(matches, (Transform)ROW_TO_CLIENT));
            if (existing != null) {
                List<ApprovalRequest.Scope> scopes = this.clientScopes(txn, apexListener, existing.id());
                for (ApprovalRequest.Scope scope : scopes) {
                    existing.scope(scope.id());
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{matches, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApprovalRequest.Scope> clientScopes(Transaction txn, JDBCPrincipal apexListener, MultiTenantEntityPK id) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("tenant_id", id.tenantId());
            parameters.put("id", id.entityId());
            matches = this.query(apexListener, JDBCOAuthDataAccess.GET_CLIENT_SCOPES_STMT, parameters);
            Iterator allScopes = null;
            allScopes = Iterators.transform(matches, (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes, (boolean)false);
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    private Client create(Transaction txn, Client client) {
        Client client2;
        JDBCCall insert = null;
        try {
            long tenantId = client.id().tenantId();
            Timestamp created = new Timestamp(client.metadata().created());
            insert = this.jdbc.insert(txn, INSERT_CLIENT_STMT, new String[]{"ID"});
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("name", client.name());
            params.put("description", client.description());
            params.put("auth_flow", (Object)client.authFlow());
            params.put("response_type", (Object)client.responseType());
            params.put("client_id", client.clientId());
            params.put("client_secret", client.clientSecret());
            params.put("redirect_uri", client.redirectUri());
            params.put("support_email", client.supportEmail());
            params.put("tenant_id", tenantId);
            params.put("created_by", client.metadata().createdBy());
            params.put("created", created);
            params.put("updated_by", client.metadata().updatedBy());
            params.put("updated", new Timestamp(client.metadata().updated()));
            insert.bind(params);
            Map keys = insert.execute();
            long id = ((Number)keys.get("ID")).longValue();
            client.id(MultiTenantEntityPK.key(tenantId, id));
            this.insertClientScopes(txn, client);
            client2 = client;
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Closeable[]{insert, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Closeable[]{insert, txn});
        return client2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertClientScopes(Transaction txn, Client client) throws SQLException {
        JDBCCall insertScope = null;
        try {
            long tenantId = client.id().tenantId();
            long id = client.id().entityId();
            Timestamp created = new Timestamp(client.metadata().created());
            List<MultiTenantEntityPK> clientScopes = client.scopes();
            if (!NullOrEmpty.nullOrEmpty(clientScopes)) {
                insertScope = this.jdbc.insert(txn, CREATE_CLIENT_SCOPE_STMT, new String[0]);
                for (MultiTenantEntityPK scope : clientScopes) {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("tenant_id", tenantId);
                    parameters.put("created", created);
                    parameters.put("client_id", id);
                    parameters.put("scope_id", scope.entityId());
                    parameters.put("created_by", client.metadata().createdBy());
                    parameters.put("created", created);
                    parameters.put("updated_by", client.metadata().updatedBy());
                    parameters.put("updated", new Timestamp(client.metadata().updated()));
                    insertScope.bind(parameters);
                    insertScope.batch();
                }
                insertScope.execute();
            }
        }
        finally {
            Closeables.close(insertScope);
        }
    }

    private Transaction newTransaction(JDBCPrincipal apexListener) {
        try {
            return this.jdbc.transaction((Principal)apexListener);
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
    }

    private Iterator<ResultRow> query(JDBCPrincipal apexListener, Statement stmt, Map<String, Object> parameters) {
        return this.query.query((Principal)apexListener, stmt, parameters);
    }

    private Client update(Transaction txn, Client client) {
        Client client2;
        JDBCCall update = null;
        try {
            update = this.jdbc.call(txn, UPDATE_CLIENT_STMT);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tenant_id", client.id().tenantId());
            params.put("id", client.id().entityId());
            params.put("name", client.name());
            params.put("description", client.description());
            params.put("response_type", (Object)client.responseType());
            params.put("client_id", client.clientId());
            params.put("client_secret", client.clientSecret());
            params.put("redirect_uri", client.redirectUri());
            params.put("support_email", client.supportEmail());
            params.put("updated_by", client.metadata().updatedBy());
            params.put("updated", new Timestamp(client.metadata().updated()));
            update.bind(params);
            update.execute();
            this.deleteClientScopes(txn, client);
            this.insertClientScopes(txn, client);
            client2 = client;
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(update);
                throw throwable;
            }
        }
        Closeables.close((Object)update);
        return client2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteClientScopes(Transaction txn, Client client) throws SQLException {
        JDBCCall deleteScopes = null;
        try {
            long tenantId = client.id().tenantId();
            long id = client.id().entityId();
            deleteScopes = this.jdbc.call(txn, DELETE_CLIENT_SCOPE_STMT);
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            parameters.put("tenant_id", tenantId);
            parameters.put("client_id", id);
            deleteScopes.bind(parameters);
            deleteScopes.execute();
        }
        catch (Throwable throwable) {
            Closeables.close(deleteScopes);
            throw throwable;
        }
        Closeables.close((Object)deleteScopes);
    }
}

