/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.security.Principal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.EntityReaderBase;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.json.JSONProperty;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.tenants.TenantPrincipal;

public class ClientReader
extends EntityReaderBase<MultiTenantEntity, Client> {
    @Override
    protected Client newEntity() {
        return new Client();
    }

    @Override
    protected void processProperty(CompoundPrincipal principal, Client client, String name, JSONProperty prop) {
        if ("name".equals(name)) {
            client.name(ClientReader.string(prop));
        } else if ("description".equals(name)) {
            client.description(ClientReader.string(prop));
        } else if ("redirectUri".equals(name)) {
            client.redirectUri(ClientReader.string(prop));
        } else if ("responseType".equals(name)) {
            client.responseType(ApprovalRequest.ResponseType.valueOf(ClientReader.string(prop).toUpperCase()));
        } else if ("supportEmail".equals(name)) {
            client.supportEmail(ClientReader.string(prop));
        } else if ("scopes".equals(name)) {
            TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
            long tenantId = TenantPrincipal.id(tenant);
            Iterable<Long> scopeIds = ClientReader.array(prop, Long.class);
            for (Long id : scopeIds) {
                client.scope(MultiTenantEntityPK.key(tenantId, id));
            }
        }
    }
}

