/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.authorization.AdditionalRolesMapper;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.config.GetConfigurations;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityType;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.oauth.bdb.Approval;
import oracle.dbtools.rt.oauth.bdb.Approvals;
import oracle.dbtools.rt.oauth.bdb.BDBClientsProvider;
import oracle.dbtools.rt.oauth.bdb.BDBScopesProvider;
import oracle.dbtools.rt.oauth.bdb.BuiltInScope;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.web.WebException;

@Service(provides={BuiltInScopes.class, OAuthScopeProvider.class}, immediate=true)
public class BuiltInScopes
implements OAuthScopeProvider {
    @Reference
    private Approvals approvals;
    @Reference
    private BDBClientsProvider clients;
    @Reference
    private BDBScopesProvider scopes;
    @Reference
    private DataStore store;
    public static String ADMIN_ROLE = "Admin";
    private static final String CONF_CLIENT = "conf.client.listener.apex.dbtools.oracle.com";
    private static final MultiTenantEntityPK CONF_CLIENT_ID = MultiTenantEntityPK.key(-2L, -3L);
    private static final BuiltInScope CONFIGURATIONS = new BuiltInScope("confs", "Create and modify the Listener configuration", -3L);
    private static final String CONFIGURATIONS_CLIENT_ID = "IsZv_-R511-vq79m880SQA..";
    private static final String CONFIGURATIONS_CLIENT_SECRET = "jd_YBIA05bzscsCI1q4Snw..";
    private static final BuiltInScope OAUTH2 = new BuiltInScope("oauth", "Register OAuth2 clients", -1L);
    private static final String OAUTH2_UI = "ui.oauth2.listener.apex.dbtools.oracle.com";
    private static final MultiTenantEntityPK OAUTH2_UI_APPROVAL_ID = MultiTenantEntityPK.key(-2L, -3L);
    private static final MultiTenantEntityPK OAUTH2_UI_ID = MultiTenantEntityPK.key(-2L, -2L);
    private static final int ONE_HOUR = 3600000;
    private static final BuiltInScope RESOURCE_TEMPLATES = new BuiltInScope("rt", "Create and modify Resource Templates", -2L);
    static final List<BuiltInScope> BUILT_IN_SCOPES = Arrays.asList(OAUTH2, RESOURCE_TEMPLATES, CONFIGURATIONS);

    public static boolean isBuiltIn(MultiTenantEntityPK id) {
        return -2L == id.tenantId();
    }

    public Pair<String, String> exchangeSessionForBearerToken(CompoundPrincipal principal) {
        Transaction txn = this.store.newTransaction();
        try {
            if (this.authorizeScope(principal, OAUTH2.id())) {
                String user = this.user((Principal)principal);
                long now = System.currentTimeMillis();
                long tokenExpiry = now + 3600000L;
                Approval adminUser = this.approval(txn, user);
                if (adminUser == null) {
                    adminUser = new Approval();
                    adminUser.id(OAUTH2_UI_APPROVAL_ID);
                    adminUser.bearerToken(Identifiers.randomIdentifier());
                    adminUser.refreshToken(Identifiers.randomIdentifier());
                    adminUser.clientId(OAUTH2_UI_ID);
                    adminUser.scope(OAUTH2.id());
                    adminUser.status(ApprovalRequest.Status.APPROVED);
                    adminUser.tokenExpiry(tokenExpiry);
                    adminUser.userId(user);
                    adminUser.metadata().entityType(EntityType.BUILTIN);
                    adminUser = this.approvals.store(StoreMode.CREATE, txn, principal, adminUser);
                } else {
                    adminUser.bearerToken(Identifiers.randomIdentifier());
                    adminUser.refreshToken(Identifiers.randomIdentifier());
                    adminUser.tokenExpiry(tokenExpiry);
                    adminUser = this.approvals.store(StoreMode.UPDATE, txn, principal, adminUser);
                }
                Pair pair = Pair.pair((Object)adminUser.bearerToken(), (Object)adminUser.refreshToken());
                return pair;
            }
            throw WebException.forbidden();
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    @Override
    public MultiTenantEntityPK scopeForPath(CompoundPrincipal principal, String path) {
        if (OAuthProfile.CLIENT_URI_TEMPLATES.matches(path) || OAuthProfile.SCOPE_URI_TEMPLATES.matches(path)) {
            return OAUTH2.id();
        }
        if (ResourceTemplatesProfile.URI_TEMPLATES.matches(path)) {
            return RESOURCE_TEMPLATES.id();
        }
        if (GetConfigurations.URI_TEMPLATE.matches(path)) {
            return CONFIGURATIONS.id();
        }
        return null;
    }

    @Override
    public Iterable<ApprovalRequest.Scope> scopes(CompoundPrincipal principal) {
        return Iterables.transform(BUILT_IN_SCOPES, (Transform)new Transform<BuiltInScope, ApprovalRequest.Scope>(){

            public ApprovalRequest.Scope apply(BuiltInScope x) {
                return x.scope();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ServiceProperties props) {
        Transaction txn = this.store.newTransaction();
        CompoundPrincipal principal = null;
        try {
            for (BuiltInScope builtIn : BUILT_IN_SCOPES) {
                this.store(txn, builtIn);
            }
            this.registerOAuthUIClient(txn, principal);
            this.registerConfClient(txn, principal);
            this.mapAdminScopesToRoles();
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Approval approval(Transaction txn, String user) {
        Iterable<Approval> approvals = this.approvals.forUserId(txn, user);
        try {
            for (Approval approval : approvals) {
                if (!OAUTH2_UI_ID.equals(approval.clientId())) continue;
                Approval approval2 = approval;
                return approval2;
            }
            Approval approval = null;
            return approval;
        }
        finally {
            Closeables.close(approvals);
        }
    }

    private boolean authorizeScope(CompoundPrincipal principal, MultiTenantEntityPK scopeId) {
        AuthorizationPolicy.Access access = AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        for (ScopeAuthorizationPolicy policy : ServiceLocator.acquireAll(ScopeAuthorizationPolicy.class, (String[])new String[0])) {
            AuthorizationPolicy.Access result = policy.authorize((Principal)principal, scopeId);
            if (AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN == result) continue;
            access = result;
            break;
        }
        return AuthorizationPolicy.Access.NONE != access && AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN != access;
    }

    private void mapAdminScopesToRoles() {
        AdditionalRolesMapper roles = (AdditionalRolesMapper)ServiceLocator.acquire(AdditionalRolesMapper.class);
        String[] adminRoles = new String[BUILT_IN_SCOPES.size()];
        for (int i = 0; i < adminRoles.length; ++i) {
            adminRoles[i] = BUILT_IN_SCOPES.get(i).name();
        }
        roles.map(ADMIN_ROLE, adminRoles);
    }

    private void registerConfClient(Transaction txn, CompoundPrincipal principal) {
        Client confClient = (Client)this.clients.entity(txn, principal, CONF_CLIENT_ID);
        if (confClient == null) {
            confClient = new Client();
            confClient.id(CONF_CLIENT_ID);
            confClient.authFlow(ApprovalRequest.AuthFlow.PASSWORD);
            confClient.responseType(ApprovalRequest.ResponseType.CODE);
            confClient.description("Oracle Application Express Listener Configuration Client");
            confClient.name(CONF_CLIENT);
            confClient.clientId(CONFIGURATIONS_CLIENT_ID);
            confClient.clientSecret(CONFIGURATIONS_CLIENT_SECRET);
            confClient.scope(CONFIGURATIONS.id());
            confClient.metadata().entityType(EntityType.BUILTIN);
            confClient = this.clients.store(StoreMode.CREATE, txn, principal, confClient);
        }
    }

    private void registerOAuthUIClient(Transaction txn, CompoundPrincipal principal) {
        Client oauth2UI = (Client)this.clients.entity(txn, principal, OAUTH2_UI_ID);
        if (oauth2UI == null) {
            oauth2UI = new Client();
            oauth2UI.id(OAUTH2_UI_ID);
            oauth2UI.authFlow(ApprovalRequest.AuthFlow.EXCHANGE);
            oauth2UI.responseType(ApprovalRequest.ResponseType.TOKEN);
            oauth2UI.description("Oracle Application Express Listener OAuth2 Client Registration");
            oauth2UI.name(OAUTH2_UI);
            oauth2UI.scope(OAUTH2.id());
            oauth2UI.redirectUri("oauth2/native");
            oauth2UI.responseType(ApprovalRequest.ResponseType.TOKEN);
            oauth2UI.metadata().entityType(EntityType.BUILTIN);
            oauth2UI = this.clients.store(StoreMode.CREATE, txn, principal, oauth2UI);
        }
    }

    private void store(Transaction txn, BuiltInScope builtIn) {
        CompoundPrincipal principal = null;
        Scope scope = (Scope)this.scopes.entity(txn, principal, builtIn.id());
        if (scope == null) {
            scope = new Scope();
            scope.id(builtIn.id());
            scope.name(builtIn.name());
            scope.description(builtIn.description());
            scope.metadata().entityType(EntityType.BUILTIN);
            scope = this.scopes.store(StoreMode.CREATE, txn, principal, scope);
        }
    }

    private String user(Principal principal) {
        if (!(principal instanceof AnonymousPrincipal)) {
            return principal.getName();
        }
        return null;
    }

    public static String[] oauthRoles() {
        return new String[]{OAUTH2.name()};
    }
}

