/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.IdGenerator;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.OAuthAuthorization;
import oracle.dbtools.rt.oauth.OAuthDataAccess;
import oracle.dbtools.rt.oauth.OAuthException;
import oracle.dbtools.rt.oauth.bdb.Approval;
import oracle.dbtools.rt.oauth.bdb.Approvals;
import oracle.dbtools.rt.oauth.bdb.BDBClientsProvider;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.tenants.TenantPrincipal;

@Service(provides={BDBOAuthDataAccess.class, OAuthDataAccess.class})
public class BDBOAuthDataAccess
implements OAuthDataAccess {
    private static final long ONE_HOUR = 3600000L;
    @Reference
    private Approvals approvals;
    @Reference
    private BDBClientsProvider clients;
    @Reference
    private IdGenerator idGenerator;
    @Reference
    private DataStore store;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BearerTokenVerification accessGranted(CompoundPrincipal principal, MultiTenantEntityPK scopeId, String bearerToken) {
        Transaction txn = null;
        try {
            txn = this.store.newTransaction();
            Approval approval = this.approvals.byBearerToken(txn, bearerToken);
            if (approval != null) {
                BearerTokenVerification bearerTokenVerification = OAuthAuthorization.verifyApproval(scopeId, new Timestamp(approval.tokenExpiry()), new Timestamp(System.currentTimeMillis()), approval.userId(), approval.scopes());
                return bearerTokenVerification;
            }
            BearerTokenVerification bearerTokenVerification = BearerTokenVerification.unknown();
            return bearerTokenVerification;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApprovalRequest approvalRequest(CompoundPrincipal principal, String userId, String clientId) {
        Iterable<Approval> matches;
        Transaction txn;
        block4: {
            ApprovalRequest approvalRequest;
            txn = this.store.newTransaction();
            matches = null;
            try {
                Client client = this.clients.byClientId(txn, principal, clientId);
                if (client == null) break block4;
                matches = this.approvals.forUserId(txn, userId);
                for (Approval approval : matches) {
                    if (!client.id().equals(approval.clientId())) break block5;
                    approvalRequest = this.approvalRequest(txn, client, approval);
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{matches, txn});
                throw throwable;
            }
            {
                block5: {
                    Closeables.close((Object[])new Object[]{matches, txn});
                    return approvalRequest;
                }
                continue;
            }
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return null;
    }

    @Override
    public ApprovalRequest approvalRequest(CompoundPrincipal principal, Transaction txn, OAuthAuthorization.OAuthClient oauthClient, String refreshToken) {
        Approval approval = this.approvals.byRefreshToken(txn, refreshToken);
        Client client = this.clients.byClientId(txn, principal, oauthClient.clientId);
        if (approval == null) {
            throw OAuthException.error(OAuthException.Error.INVALID_REQUEST);
        }
        if (client == null) {
            throw OAuthException.error(OAuthException.Error.INVALID_CLIENT);
        }
        if (approval.clientId() != client.id() || approval.status() != ApprovalRequest.Status.APPROVED) {
            throw OAuthException.error(OAuthException.Error.INVALID_GRANT);
        }
        return this.approvalRequest(txn, client, approval);
    }

    @Override
    public OAuthAuthorization.OAuthClient client(Transaction txn, CompoundPrincipal principal, String clientId) {
        Client client = this.clients.byClientId(txn, principal, clientId);
        if (client != null) {
            OAuthAuthorization.OAuthClient oauthClient = new OAuthAuthorization.OAuthClient();
            oauthClient.id = client.id();
            oauthClient.clientId = client.clientId();
            oauthClient.description = client.description();
            oauthClient.email = client.supportEmail();
            oauthClient.name = client.name();
            oauthClient.redirectUri = client.redirectUri();
            oauthClient.authFlow = client.authFlow();
            oauthClient.responseType = client.responseType();
            ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>(client.scopes().size());
            for (MultiTenantEntityPK id : client.scopes()) {
                scopes.add(new ApprovalRequest.Scope(id));
            }
            oauthClient.scopes = Collections.unmodifiableList(scopes);
            return oauthClient;
        }
        return null;
    }

    @Override
    public void createApprovalRequest(CompoundPrincipal principal, ApprovalRequest ar) {
        Transaction txn = this.store.newTransaction();
        try {
            Approval approval = new Approval();
            approval.id(this.idGenerator.multiTenantId(TenantPrincipal.tenant((Principal)principal)));
            approval.userId(ar.userId());
            approval.clientId(ar.clientKey());
            approval.status(ApprovalRequest.Status.PENDING);
            for (ApprovalRequest.Scope scope : ar.scopes()) {
                approval.scope(scope.id());
            }
            this.approvals.store(StoreMode.CREATE, txn, principal, approval);
            ar.id(approval.id());
        }
        catch (RuntimeException e) {
            txn.rollbackOnly();
            throw e;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    @Override
    public void deleteApprovalRequest(CompoundPrincipal principal, MultiTenantEntityPK id) {
        Transaction txn = this.store.newTransaction();
        try {
            this.approvals.delete(txn, principal, id);
        }
        catch (RuntimeException e) {
            txn.rollbackOnly();
            throw e;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.store.newTransaction();
    }

    @Override
    public ApprovalRequest updateStatus(CompoundPrincipal principal, MultiTenantEntityPK id, String expectedUserId, ApprovalRequest.Status newStatus, ApprovalRequest.Status ... expectedStatus) {
        ApprovalRequest ar;
        block6: {
            ar = null;
            Transaction txn = this.store.newTransaction();
            try {
                Approval approval = (Approval)this.approvals.entity(txn, principal, id);
                if (approval != null && approval.userId().equals(expectedUserId) && this.expectedStatus(approval.status(), expectedStatus)) {
                    Client client = (Client)this.clients.entity(txn, principal, approval.clientId());
                    approval.status(newStatus);
                    this.approvals.store(StoreMode.UPDATE, txn, principal, approval);
                    ar = this.approvalRequest(txn, client, approval);
                    break block6;
                }
                throw OAuthException.error(OAuthException.Error.INVALID_REQUEST);
            }
            catch (RuntimeException e) {
                txn.rollbackOnly();
                throw e;
            }
            finally {
                Closeables.close((Object)txn);
            }
        }
        return ar;
    }

    @Override
    public Pair<String, String> createUserSession(CompoundPrincipal principal, String bearerToken, String refreshToken, ApprovalRequest ar) {
        Transaction txn = this.store.newTransaction();
        try {
            Approval approval = (Approval)this.approvals.entity(txn, principal, ar.id());
            if (approval != null) {
                if (approval.tokenExpiry() > System.currentTimeMillis()) {
                    Pair pair = Pair.pair((Object)approval.bearerToken(), (Object)approval.refreshToken());
                    return pair;
                }
                approval.bearerToken(bearerToken);
                approval.tokenExpiry(System.currentTimeMillis() + 3600000L);
                this.approvals.store(StoreMode.UPDATE, txn, principal, approval);
            }
        }
        catch (RuntimeException e) {
            txn.rollbackOnly();
            throw e;
        }
        finally {
            Closeables.close((Object)txn);
        }
        return Pair.pair((Object)bearerToken, (Object)refreshToken);
    }

    private ApprovalRequest approvalRequest(Transaction txn, Client client, Approval approval) {
        ApprovalRequest.Builder b = ApprovalRequest.builder();
        b.clientId(client.clientId());
        b.clientKey(client.id());
        b.clientSecret(client.clientSecret());
        b.description(client.description());
        b.email(client.supportEmail());
        b.id(approval.id());
        b.name(client.name());
        b.redirectUri(client.redirectUri());
        b.responseType(client.responseType());
        b.status(approval.status());
        b.title(client.name());
        b.userId(approval.userId());
        for (MultiTenantEntityPK id : approval.scopes()) {
            b.scope(new ApprovalRequest.Scope(id));
        }
        return b.build();
    }

    private boolean expectedStatus(ApprovalRequest.Status actualStatus, ApprovalRequest.Status ... expectedStatuses) {
        for (ApprovalRequest.Status expectedStatus : expectedStatuses) {
            if (!expectedStatus.equals((Object)actualStatus)) continue;
            return true;
        }
        return false;
    }
}

