/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import com.sleepycat.persist.SecondaryIndex;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.BaseMultiTenantEntityStorageProvider;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.ClientsProvider;

@Service(provides={BDBClientsProvider.class, ClientsProvider.class})
public class BDBClientsProvider
extends BaseMultiTenantEntityStorageProvider<Client>
implements ClientsProvider {
    private SecondaryIndex<String, MultiTenantEntityPK, Client> clientByName;
    private SecondaryIndex<String, MultiTenantEntityPK, Client> clientByClientId;
    private SecondaryIndex<String, MultiTenantEntityPK, Client> clientByCreatedBy;

    @Override
    public Client store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, Client instance) {
        return super.store(storeMode, txn, principal, instance);
    }

    @Override
    public Client byClientId(Transaction txn, CompoundPrincipal principal, String clientId) {
        return (Client)this.clientByClientId.get(DataStore.unwrap(txn), (Object)clientId, null);
    }

    @Override
    public Iterable<Client> byCreatedBy(Transaction txn, CompoundPrincipal principal) {
        String user = principal.getName();
        return this.clientByCreatedBy.subIndex((Object)user).entities(DataStore.unwrap(txn), null);
    }

    @Override
    public Client exists(Transaction txn, CompoundPrincipal principal, Client instance) {
        return (Client)this.clientByName.get(DataStore.unwrap(txn), (Object)instance.name(), null);
    }

    @Override
    protected void activate(ServiceProperties props) {
        super.activate(props);
        this.clientByName = this.entities.getSecondaryIndex(String.class, "name");
        this.clientByClientId = this.entities.getSecondaryIndex(String.class, "clientId");
        this.clientByCreatedBy = this.entities.getSecondaryIndex(String.class, "createdBy");
    }

    @Override
    protected Class<Client> entityType() {
        return Client.class;
    }
}

