/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

public class ApprovalRequest {
    private String clientId;
    private MultiTenantEntityPK clientKey;
    private String clientSecret;
    private String description;
    private String email;
    private MultiTenantEntityPK id;
    private String name;
    private String redirectUri;
    private ResponseType responseType = ResponseType.CODE;
    private final Set<Scope> scopes = new TreeSet<Scope>();
    private String state = null;
    private Status status = Status.PENDING;
    private String title;
    private String userId;

    private ApprovalRequest() {
    }

    public String clientId() {
        return this.clientId;
    }

    public MultiTenantEntityPK clientKey() {
        return this.clientKey;
    }

    public ApprovalRequest clientKey(MultiTenantEntityPK clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public ApprovalRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ApprovalRequest description(String description) {
        this.description = description;
        return this;
    }

    public String email() {
        return this.email;
    }

    public ApprovalRequest email(String email) {
        this.email = email;
        return this;
    }

    public MultiTenantEntityPK id() {
        return this.id;
    }

    public ApprovalRequest id(MultiTenantEntityPK id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ApprovalRequest name(String name) {
        this.name = name;
        return this;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public ApprovalRequest redirectUri(String uri) {
        this.redirectUri = uri;
        return this;
    }

    public ResponseType responseType() {
        return this.responseType;
    }

    public Set<Scope> scopes() {
        return this.scopes;
    }

    public String state() {
        return this.state;
    }

    public Status status() {
        return this.status;
    }

    public ApprovalRequest status(Status status) {
        this.status = status;
        return this;
    }

    public String title() {
        return this.title;
    }

    public ApprovalRequest title(String title) {
        this.title = title;
        return this;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ApprovalRequest [clientId=");
        builder2.append(this.clientId);
        builder2.append(", clientKey=");
        builder2.append(this.clientKey);
        builder2.append(", clientSecret=");
        builder2.append(this.clientSecret);
        builder2.append(", description=");
        builder2.append(this.description);
        builder2.append(", email=");
        builder2.append(this.email);
        builder2.append(", id=");
        builder2.append(this.id);
        builder2.append(", name=");
        builder2.append(this.name);
        builder2.append(", redirectUri=");
        builder2.append(this.redirectUri);
        builder2.append(", responseType=");
        builder2.append((Object)this.responseType);
        builder2.append(", scopes=");
        builder2.append(this.scopes);
        builder2.append(", state=");
        builder2.append(this.state);
        builder2.append(", status=");
        builder2.append((Object)this.status);
        builder2.append(", title=");
        builder2.append(this.title);
        builder2.append(", userId=");
        builder2.append(this.userId);
        builder2.append("]");
        return builder2.toString();
    }

    public String userId() {
        return this.userId;
    }

    public ApprovalRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ApprovalRequest approvalRequest(RequestEntity request) {
        ApprovalRequest ar = new ApprovalRequest();
        List<Pair<String, Object>> formFields = Requests.formFields(request);
        for (Pair<String, Object> field : formFields) {
            String name = (String)field.first();
            String text = field.second().toString();
            if ("response_type".equalsIgnoreCase(name)) {
                if ("token".equalsIgnoreCase(text)) {
                    ar.responseType = ResponseType.TOKEN;
                    continue;
                }
                if ("code".equalsIgnoreCase(text)) {
                    ar.responseType = ResponseType.CODE;
                    continue;
                }
                ar.responseType = ResponseType.UNKNOWN;
                continue;
            }
            if ("client_id".equalsIgnoreCase(name)) {
                ar.clientId = text;
                continue;
            }
            if ("redirect_uri".equalsIgnoreCase(name)) {
                ar.redirectUri = text;
                continue;
            }
            if (!"state".equals(name)) continue;
            ar.state = text;
        }
        return ar;
    }

    public static ApprovalRequest approvalRequest(ResultRow row) {
        ApprovalRequest ar = new ApprovalRequest();
        ColumnIterator columns = new ColumnIterator(row);
        long tenantId = (Long)columns.next(Long.class);
        long approvalId = (Long)columns.next(Long.class);
        ar.id = MultiTenantEntityPK.key(tenantId, approvalId);
        ar.userId = (String)columns.next(String.class);
        ar.clientKey = MultiTenantEntityPK.key(tenantId, (Long)columns.next(Long.class));
        ar.status = Status.valueOf((String)columns.next(String.class));
        ar.name = (String)columns.next(String.class);
        ar.description = (String)columns.next(String.class);
        ar.responseType = ResponseType.valueOf((String)columns.next(String.class));
        ar.clientId = (String)columns.next(String.class);
        ar.clientSecret = (String)columns.next(String.class);
        ar.redirectUri = (String)columns.next(String.class);
        ar.email = (String)columns.next(String.class);
        return ar;
    }

    public static Scope scope(String name, MultiTenantEntityPK id) {
        Scope scope = new Scope(id);
        scope.name(name);
        return scope;
    }

    private static void scopes(ApprovalRequest ar, String text) {
        String[] segments = Text.spaceDelimited((String)text);
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            Scope scope = Scope.valueOf(segment);
            ar.scopes.add(scope);
        }
    }

    public static enum Status {
        APPROVED,
        DENIED,
        PENDING;

    }

    public static class Scope
    implements Comparable<Scope> {
        private String description;
        private final MultiTenantEntityPK id;
        private String name;
        private String title;
        private static final Pattern PATTERN = Pattern.compile("^(-?\\d+\\.-?\\d+):(.+)");

        public Scope(MultiTenantEntityPK id) {
            this.id = id;
        }

        @Override
        public int compareTo(Scope o) {
            return this.id.compareTo(o.id);
        }

        public String description() {
            return this.description;
        }

        public void description(String description) {
            this.description = description;
        }

        public MultiTenantEntityPK id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public void name(String name) {
            this.name = name;
        }

        public String title() {
            return this.title;
        }

        public void title(String title) {
            this.title = title;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.id);
            builder.append(":");
            builder.append(this.name);
            return builder.toString();
        }

        public static Scope valueOf(String text) {
            Matcher m = PATTERN.matcher(text);
            if (m.matches()) {
                String key = m.group(1);
                String name = m.group(2);
                Scope scope = new Scope(MultiTenantEntityPK.valueOf(key));
                scope.name(name);
                return scope;
            }
            throw new IllegalStateException();
        }
    }

    public static enum ResponseType {
        CODE,
        TOKEN,
        UNKNOWN;

    }

    public static class Builder {
        private final ApprovalRequest ar = new ApprovalRequest();

        private Builder() {
        }

        public ApprovalRequest build() {
            return this.ar;
        }

        public Builder clientId(String clientId) {
            this.ar.clientId = clientId;
            return this;
        }

        public Builder clientKey(MultiTenantEntityPK clientKey) {
            this.ar.clientKey = clientKey;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.ar.clientSecret = clientSecret;
            return this;
        }

        public Builder description(String description) {
            this.ar.description = description;
            return this;
        }

        public Builder email(String email) {
            this.ar.email = email;
            return this;
        }

        public Builder id(MultiTenantEntityPK id) {
            this.ar.id = id;
            return this;
        }

        public Builder name(String name) {
            this.ar.name = name;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.ar.redirectUri = redirectUri;
            return this;
        }

        public Builder responseType(ResponseType responseType) {
            this.ar.responseType = responseType;
            return this;
        }

        public Builder state(String state) {
            this.ar.state = state;
            return this;
        }

        public Builder status(Status status) {
            this.ar.status = status;
            return this;
        }

        public Builder title(String title) {
            this.ar.title = title;
            return this;
        }

        public Builder userId(String userId) {
            this.ar.userId = userId;
            return this;
        }

        public void scope(Scope scope) {
            this.ar.scopes.add(scope);
        }
    }

    public static enum AuthFlow {
        AUTH_TOKEN,
        CLIENT_CRED,
        IMPLICIT,
        PASSWORD,
        EXCHANGE;

    }
}

