/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.io.IOException;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.json.xml.XMLToJSON;
import oracle.dbtools.rt.transcode.Transcoders;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

@Service(provides={RequestDispatcher.class})
public class JSONDispatcher
extends ReTargetingDispatcher<ReTargetingDispatcher.Target> {
    @Reference
    private Transcoders transcoders;

    @Override
    protected EntityHeaders forwardedHeaders(ReTargetingDispatcher.Target target, RequestEntity request) {
        return this.prefer(ContentTypes.JSON_TYPES);
    }

    @Override
    protected RequestEntity modifyRequest(ReTargetingDispatcher.Target target, RequestEntity request) throws IOException {
        RequestEntity newRequest = null;
        newRequest = Requests.hasContent(request) ? Requests.merge(request, this.transcoders.transform(this.prefer(request, target.target(), ContentTypes.XML_TYPES))) : super.modifyRequest(target, newRequest);
        return newRequest;
    }

    @Override
    protected Entity modifyResponse(ReTargetingDispatcher.Target target, Entity response) throws IOException {
        return this.transcoders.transform(this.prefer(response, target.target(), ContentTypes.JSON_TYPES));
    }

    @Override
    protected ReTargetingDispatcher.Target target(RequestEntity request) {
        String match = XMLToJSON.match(request.path());
        if (match == null) {
            return null;
        }
        return new ReTargetingDispatcher.Target(match);
    }

    private EntityHeaders prefer(ContentType ... preferred) {
        EntityHeadersBuilder preferedHeaders = Entities.headers();
        CharSequence[] types = new CharSequence[preferred.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = preferred[i];
        }
        preferedHeaders.header((CharSequence)"X-APEX-PREFERRED-CONTENT-TYPE", types);
        return preferedHeaders.build();
    }

    private Entity prefer(Entity entity, String docBase, ContentType ... preferred) {
        return Entities.merge(Entities.merge(entity, this.prefer(preferred)), Entities.headers("X-APEX-DOC-BASE", docBase));
    }
}

