/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONProperty;
import oracle.dbtools.rt.json.query.HyperLinks;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.query.ResultRowRepresentation;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.WebException;

public class JSONRepresentation
implements ResultRowRepresentation {
    private final boolean firstRowOnly;
    private final ContentType contentType;

    public JSONRepresentation(boolean firstRowOnly) {
        this(firstRowOnly, ContentTypes.JSON);
    }

    public JSONRepresentation(boolean firstRowOnly, ContentType contentType) {
        this.firstRowOnly = firstRowOnly;
        this.contentType = contentType;
    }

    @Override
    public Entity toRepresentation(RequestPaths paths, long pageOffset, Iterator<ResultRow> rows) throws IOException {
        ResultRow pagination;
        if (this.firstRowOnly && !rows.hasNext()) {
            throw WebException.notFound();
        }
        Iterable<JSONProperty> pageLinks = null;
        if (pageOffset != -1L && (pagination = Pagination.hyperlinks(paths.path(), pageOffset, rows)) != null) {
            pageLinks = this.pageLinks(HyperLinks.hyperlink(paths.base(), Iterators.iterator((Object[])new ResultRow[]{pagination})).next());
        }
        Iterator<ResultRow> hyperlinked = HyperLinks.hyperlink(paths.documentBase(), rows);
        return Entities.entity((InputStream)((Object)new JSONQueryStream(hyperlinked, this.firstRowOnly, pageLinks)), Entities.headers(HttpHeader.CONTENT_TYPE, this.contentType));
    }

    private Iterable<JSONProperty> pageLinks(ResultRow hyperlinks) {
        return (JSONObject)JSONQueryStream.toJson(hyperlinks).build();
    }
}

