/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONRepresentation;
import oracle.dbtools.rt.query.QueryGeneratorBase;
import oracle.dbtools.rt.query.ResultRowRepresentation;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.FeedItemTransform;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.RequestPaths;

@Service(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="json/query;type=feed"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorLabel", value="JSON Feed Query"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorDescription", value="Transform the results of the supplied query into a JSON Feed document"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorExample", value="select * from oe.orders where order_id = :id ")})
public class JSONFeedGenerator
extends QueryGeneratorBase
implements ResourceGenerator {
    public static final String JSON_FEED_TYPE = "json/query;type=feed";
    private final ResultRowRepresentation rep = new JSONRepresentation(false);

    private Iterator<FeedItem> items(Iterator<ResultRow> rows) {
        return Iterators.transform(rows, (Transform)new Transform<ResultRow, FeedItem>(){

            public FeedItem apply(final ResultRow x) {
                return new FeedItem(){

                    @Override
                    public ResultRow item() {
                        return x;
                    }

                    @Override
                    public String id() {
                        return PrimitiveTypes.string((Object)x.get(1));
                    }

                    @Override
                    public ContentType contentType() {
                        return ContentTypes.JSON;
                    }
                };
            }
        });
    }

    private URITemplate itemTemplate(RequestPaths paths) {
        return new URITemplate(paths.path() + "/{id}");
    }

    @Override
    protected Entity toRepresentation(RequestPaths paths, long pageOffset, Iterator<ResultRow> rows) throws IOException {
        URITemplate itemTemplate = this.itemTemplate(paths);
        String base = paths.base();
        Iterator<FeedItem> items = this.items(rows);
        return this.rep.toRepresentation(paths, pageOffset, Iterators.transform(items, (Transform)new FeedItemTransform(itemTemplate, base)));
    }
}

