/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.tenants;

import com.sleepycat.persist.model.KeyField;
import com.sleepycat.persist.model.Persistent;

@Persistent
public class MultiTenantEntityPK
implements Comparable<MultiTenantEntityPK> {
    @KeyField(value=2)
    private long entityId;
    @KeyField(value=1)
    private long tenantId;
    public static final MultiTenantEntityPK NO_PARENT = null;

    private MultiTenantEntityPK() {
    }

    private MultiTenantEntityPK(long tenantId, long entityId) {
        this.tenantId = tenantId;
        this.entityId = entityId;
    }

    @Override
    public int compareTo(MultiTenantEntityPK o) {
        long result = this.tenantId - o.tenantId;
        if (result == 0L) {
            result = this.entityId - o.entityId;
        }
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    public long entityId() {
        return this.entityId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTenantEntityPK other = (MultiTenantEntityPK)obj;
        if (this.entityId != other.entityId) {
            return false;
        }
        return this.tenantId == other.tenantId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.entityId ^ this.entityId >>> 32);
        result = 31 * result + (int)(this.tenantId ^ this.tenantId >>> 32);
        return result;
    }

    public long tenantId() {
        return this.tenantId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tenantId);
        builder.append(".");
        builder.append(this.entityId);
        return builder.toString();
    }

    public static MultiTenantEntityPK valueOf(String text) {
        String[] segments = text.split("\\.");
        long tenantId = Long.parseLong(segments[0]);
        long entityId = Long.parseLong(segments[1]);
        return MultiTenantEntityPK.key(tenantId, entityId);
    }

    public static MultiTenantEntityPK key(long tenantId, long entityId) {
        return new MultiTenantEntityPK(tenantId, entityId);
    }

    public static MultiTenantEntityPK from(long tenantId) {
        return MultiTenantEntityPK.key(tenantId, 0L);
    }

    public static MultiTenantEntityPK to(long tenantId) {
        return MultiTenantEntityPK.key(tenantId, Integer.MAX_VALUE);
    }
}

