/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home.global;

import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.global.GlobalEntity;
import oracle.dbtools.rt.home.global.GlobalEntityStorage;

public abstract class BaseGlobalStorageProvider<T extends GlobalEntity>
implements EntityStorage<Long, T> {
    @Reference
    protected DataStore store;
    protected GlobalEntityStorage<T> entities;

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.entities.newTransaction(principal);
    }

    @Override
    public Iterable<Long> childIds(Transaction txn, CompoundPrincipal principal, Long id) {
        return this.entities.childIds(txn, principal, id);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, Long entityId) {
        this.entities.delete(txn, principal, entityId);
    }

    @Override
    public T entity(Transaction txn, CompoundPrincipal principal, Long entityId) {
        return (T)((GlobalEntity)this.entities.entity(txn, principal, entityId));
    }

    @Override
    public T store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, T instance) {
        return (T)((GlobalEntity)this.entities.store(storeMode, txn, principal, instance));
    }

    protected void activate(ServiceProperties props) {
        this.entities = new GlobalEntityStorage<T>(this.store, this.entityType());
    }

    protected abstract Class<T> entityType();
}

