/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import java.util.EventListener;
import oracle.dbtools.rt.home.EntityType;

@Persistent(version=1)
public class EntityMetaData {
    private long created = -1L;
    private String createdBy = "unknown";
    private EntityType entityType = null;
    private byte[] guid;
    private transient UpdateListener listener;
    private long updated = -1L;
    private String updatedBy = "unknown";
    private long version = -1L;
    public static final String UNKNOWN = "unknown";
    public static final int UNVERSIONED = -1;

    public long created() {
        return this.created;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public EntityMetaData createdBy(String createdBy, long when) {
        return this.updatedBy(UpdateType.CREATED, createdBy, when);
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public EntityMetaData entityType(EntityType entityType) {
        if (this.entityType == null) {
            this.entityType = entityType;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityMetaData other = (EntityMetaData)obj;
        if (this.created != other.created) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals((Object)other.entityType)) {
            return false;
        }
        if (!Arrays.equals(this.guid, other.guid)) {
            return false;
        }
        if (this.updated != other.updated) {
            return false;
        }
        if (this.updatedBy == null ? other.updatedBy != null : !this.updatedBy.equals(other.updatedBy)) {
            return false;
        }
        return this.version == other.version;
    }

    public byte[] guid() {
        return this.guid;
    }

    public EntityMetaData guid(byte[] guid) {
        this.guid = guid;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + Arrays.hashCode(this.guid);
        result = 31 * result + (int)(this.updated ^ this.updated >>> 32);
        result = 31 * result + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EntityMetaData [created=");
        builder.append(this.created);
        builder.append(", createdBy=");
        builder.append(this.createdBy);
        builder.append(", entityType=");
        builder.append((Object)this.entityType);
        builder.append(", guid=");
        builder.append(Arrays.toString(this.guid));
        builder.append(", updated=");
        builder.append(this.updated);
        builder.append(", updatedBy=");
        builder.append(this.updatedBy);
        builder.append(", version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }

    public long updated() {
        return this.updated;
    }

    public String updatedBy() {
        return this.updatedBy;
    }

    public EntityMetaData updatedBy(String updatedBy, long when) {
        return this.updatedBy(UpdateType.UPDATED, updatedBy, when);
    }

    private EntityMetaData updatedBy(UpdateType type, String updatedBy, long when) {
        if (type == UpdateType.CREATED) {
            this.created = when;
            this.createdBy = updatedBy;
        }
        this.updatedBy = updatedBy;
        this.updated = when;
        if (this.listener != null) {
            this.listener.updated(type, updatedBy, this.updated());
        }
        return this;
    }

    public final void updateListener(UpdateListener listener) {
        this.listener = listener;
    }

    public long version() {
        return this.version;
    }

    public EntityMetaData version(long version) {
        this.version = version;
        return this;
    }

    public static enum UpdateType {
        CREATED,
        UPDATED;

    }

    public static interface UpdateListener
    extends EventListener {
        public void updated(UpdateType var1, String var2, long var3);
    }
}

