/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import java.security.Principal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.home.GenericEntity;

public class EntityAuthorizationPolicy
implements AuthorizationPolicy<GenericEntity<?>> {
    private final AuthorizationPolicy.Access creatorAccess;
    private final AuthorizationPolicy.Access otherAccess;
    public static final AuthorizationPolicy<GenericEntity<?>> CREATOR_ONLY = new EntityAuthorizationPolicy(AuthorizationPolicy.Access.READ_WRITE, AuthorizationPolicy.Access.NONE);

    public EntityAuthorizationPolicy(AuthorizationPolicy.Access creatorAccess, AuthorizationPolicy.Access otherAccess) {
        this.creatorAccess = creatorAccess;
        this.otherAccess = otherAccess;
    }

    @Override
    public AuthorizationPolicy.Access authorize(Principal principal, GenericEntity<?> target) {
        if (principal == null) {
            return this.otherAccess;
        }
        String user = principal.getName();
        if (user == null) {
            return this.otherAccess;
        }
        String creator = target.metadata().createdBy();
        if (this.isCreator(creator, user)) {
            return this.creatorAccess;
        }
        return this.otherAccess;
    }

    protected boolean isCreator(String creator, String user) {
        if (creator == null) {
            return false;
        }
        return user.toUpperCase().equals(creator.toUpperCase());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityAuthorizationPolicy other = (EntityAuthorizationPolicy)obj;
        if (this.creatorAccess == null ? other.creatorAccess != null : !this.creatorAccess.equals((Object)other.creatorAccess)) {
            return false;
        }
        return !(this.otherAccess == null ? other.otherAccess != null : !this.otherAccess.equals((Object)other.otherAccess));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creatorAccess == null ? 0 : this.creatorAccess.hashCode());
        result = 31 * result + (this.otherAccess == null ? 0 : this.otherAccess.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EntityAuthorizationPolicy [creatorAccess=");
        builder.append((Object)this.creatorAccess);
        builder.append(", otherAccess=");
        builder.append((Object)this.otherAccess);
        builder.append("]");
        return builder.toString();
    }
}

