/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaderImpl;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.entity.EntityHeadersImpl;
import oracle.dbtools.rt.entity.EntityImpl;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public final class Entities {
    private static final DateFormat RFC_822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    private Entities() {
    }

    public static String toString(EntityHeaders headers) {
        return Iterators.join(Entities.headers(headers), (String)"\r\n");
    }

    public static Entity addValues(Entity existing, EntityHeaders additionalValues) {
        try {
            return Entities.entity(existing.body(), Entities.addValues(existing.headers(), additionalValues));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public static EntityHeaders addValues(EntityHeaders existing, EntityHeaders additionalValues) {
        EntityHeadersBuilder newHeaders = Entities.headers();
        LinkedHashSet headerNames = new LinkedHashSet();
        Iterables.add(headerNames, (Iterable)existing, (boolean)true);
        Iterables.add(headerNames, (Iterable)additionalValues);
        for (String name : headerNames) {
            newHeaders.header((CharSequence)name, Entities.merge(existing.header(name), additionalValues.header(name)));
        }
        return newHeaders.build();
    }

    public static Entity buffer(Entity entity) {
        try {
            return new BufferedEntity(entity);
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public static int compareTo(EntityHeader eh1, EntityHeader eh2) {
        String name2;
        String name1 = eh1.name().toLowerCase();
        int c = name1.compareTo(name2 = eh2.name().toLowerCase());
        if (c == 0) {
            c = Iterables.compare(eh1.values(), eh2.values());
        }
        return c;
    }

    public static Entity entity(InputStream body, EntityHeaders headers) {
        return new EntityImpl(body, headers);
    }

    public static boolean equals(EntityHeaders h1, EntityHeaders h2) {
        return h1.compareTo(h2) == 0;
    }

    public static EntityHeader header(CharSequence name, CharSequence ... values) {
        return new EntityHeaderImpl(name, values);
    }

    public static EntityHeadersBuilder headers() {
        return new EntityHeadersBuilder();
    }

    public static EntityHeaders headers(CharSequence ... headerPairs) {
        return Entities.headers().headers(headerPairs).build();
    }

    public static EntityHeaders headers(EntityHeader ... headers) {
        return Entities.headers().headers(headers).build();
    }

    public static Iterator<EntityHeader> headers(final EntityHeaders h) {
        return Iterators.transform(h.iterator(), (Transform)new Transform<String, EntityHeader>(){

            public EntityHeader apply(String x) {
                return h.header(x);
            }
        });
    }

    public static EntityHeaders headers(Iterator<EntityHeader> headers) {
        return new EntityHeadersImpl(headers);
    }

    public static Entity merge(Entity entity, EntityHeaders newValues) {
        try {
            return Entities.entity(entity.body(), Entities.merge(entity.headers(), newValues));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public static EntityHeaders merge(EntityHeaders existing, EntityHeaders newValues) {
        Iterator headers = Iterators.sequence((Iterator)Iterators.iterator((Object[])new Iterator[]{Entities.headers(existing), Entities.headers(newValues)}));
        return Entities.headers(headers);
    }

    public static String string(EntityHeader h) {
        return h.name() + ": " + Iterables.join((Iterable)h, (String)", ");
    }

    public static EntityHeaders suppress(EntityHeaders existing, CharSequence ... toSuppress) {
        ArrayList<String> names = new ArrayList<String>(toSuppress.length);
        for (CharSequence name : toSuppress) {
            names.add(((Object)name).toString());
        }
        return Entities.suppress(existing, names);
    }

    public static EntityHeaders suppress(EntityHeaders existing, List<String> toSuppress) {
        ArrayList<EntityHeader> headers = new ArrayList<EntityHeader>();
        for (String name : existing) {
            if (Iterables.contains(toSuppress, (Selector)Selectors.equalsIgnoreCase((String)name))) continue;
            headers.add(existing.header(name));
        }
        return new EntityHeadersImpl(headers.iterator());
    }

    static long toDateLong(CharSequence value) {
        try {
            if (null == value) {
                return -1L;
            }
            Date d = RFC_822_FORMAT.parse(((Object)value).toString());
            return d.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static int toInt(CharSequence value) {
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(((Object)value).toString());
    }

    private static Iterable<String> merge(EntityHeader existing, EntityHeader additional) {
        if (existing == null) {
            return additional.values();
        }
        if (additional == null) {
            return existing.values();
        }
        LinkedHashSet<String> merged = new LinkedHashSet<String>();
        Iterables.add(merged, existing.values());
        Iterables.add(merged, additional.values());
        return merged;
    }

    private static class BufferedEntity
    implements Entity {
        private final byte[] bytes;
        private final EntityHeaders headers;

        private BufferedEntity(Entity entity) throws IOException {
            this.headers = entity.headers();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            StreamCopy.drain((InputStream)entity.body(), (OutputStream)bytes);
            this.bytes = bytes.toByteArray();
        }

        @Override
        public InputStream body() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public EntityHeaders headers() {
            return this.headers;
        }
    }
}

