/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.csv.query;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.csv.CommaSeparatedValues;

public class CSVQueryStream
extends ChunkedInputStream {
    public CSVQueryStream(Iterator<ResultRow> results) {
        super((ChunkedInputStream.Chunker)new CSVChunker(results));
    }

    private static class CSVChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final Iterator<ResultRow> results;

        CSVChunker(Iterator<ResultRow> results) {
            this.results = results;
        }

        protected byte[] advance() {
            byte[] chunk = null;
            if (this.results.hasNext()) {
                ResultRow result = this.results.next();
                Object[] values = new Object[result.size()];
                for (int i = 0; i < values.length; ++i) {
                    Object value;
                    values[i] = value = result.get(i + 1);
                }
                String text = CommaSeparatedValues.string(values);
                chunk = text.getBytes(Text.defaultCharset());
            }
            return chunk;
        }

        public void close() throws IOException {
            Closeables.close(this.results);
        }
    }
}

