/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization;

import java.io.File;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.dbtools.common.config.PropertiesConfiguration;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.authentication.Principals;
import oracle.dbtools.rt.authorization.RoleMapper;
import oracle.dbtools.rt.authorization.RoleMembership;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.HasRoles;

@Service(provides={RoleMapper.class, AdditionalRolesMapper.class})
public class AdditionalRolesMapper
implements RoleMapper {
    private static final NotInfrastructurePrincipal NOT_INFRA_PRINCIPAL = new NotInfrastructurePrincipal();
    private static final AsName AS_NAME = new AsName();
    private final ConcurrentMap<String, Iterable<Principal>> additionalRoles = new ConcurrentHashMap<String, Iterable<Principal>>();
    private static final String ROLE_FILE = "role-mapping.xml";

    private Collection<Principal> additionalRoles(Iterable<Principal> principals) {
        HashSet<Principal> all = new HashSet<Principal>();
        for (Principal principal : this.filtered(principals)) {
            all.add(principal);
            String name = principal.getName();
            if (name != null && this.additionalRoles.containsKey(name)) {
                Iterables.add(all, (Iterable)((Iterable)this.additionalRoles.get(name)), (boolean)true);
            }
            if (!(principal instanceof HasRoles)) continue;
            HasRoles roles = (HasRoles)((Object)principal);
            for (String role : this.additionalRoles.keySet()) {
                if (!roles.isInRole(role)) continue;
                Iterables.add(all, (Iterable)((Iterable)this.additionalRoles.get(role)));
            }
        }
        return all;
    }

    private Iterable<Principal> filtered(Iterable<Principal> principals) {
        return Iterables.select(principals, (Selector)NOT_INFRA_PRINCIPAL);
    }

    @Override
    public RoleMembership isPrincipalInRole(Principal principal, String role) {
        RoleMembership membership = RoleMembership.NOT_KNOWN;
        HashSet additional = new HashSet();
        Iterable principals = Iterables.iterable((Object[])new Principal[]{principal});
        if (principal instanceof CompoundPrincipal) {
            principals = (CompoundPrincipal)principal;
        }
        Collection<Principal> additionalRoles = this.additionalRoles(principals);
        Iterables.add(additional, (Iterable)Iterables.transform(additionalRoles, (Transform)AS_NAME), (boolean)true);
        if (additional.contains(role)) {
            membership = RoleMembership.MEMBER;
        }
        return membership;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ServiceProperties properties) throws Exception {
        File mappings = Files.file((File)ConfigurationFolder.INSTANCE.getFolder(), (String)ROLE_FILE);
        if (mappings.exists()) {
            InputStream in = null;
            try {
                in = Files.inputStream((File)mappings);
                PropertiesConfiguration roleMappings = new PropertiesConfiguration(in);
                for (String from : roleMappings) {
                    this.map(from, Text.commaDelimited((String)((String)roleMappings.get((Object)from))));
                }
            }
            finally {
                Closeables.close((Object)in);
            }
        }
    }

    public void map(String from, String ... to) {
        HashSet additionalRoles = new HashSet();
        Iterables.add(additionalRoles, (Iterable)((Iterable)this.additionalRoles.get(from)));
        Iterables.add(additionalRoles, (Iterable)Iterables.iterable((Object[])Principals.roles(to)));
        if (!additionalRoles.isEmpty()) {
            this.additionalRoles.put(from, additionalRoles);
        }
    }

    private static class AsName
    implements Transform<Principal, String> {
        private AsName() {
        }

        public String apply(Principal x) {
            return x.getName();
        }
    }

    private static final class NotInfrastructurePrincipal
    implements Selector<Principal> {
        private NotInfrastructurePrincipal() {
        }

        public Boolean apply(Principal x) {
            if (x instanceof TenantPrincipal || x instanceof JDBCPrincipal || x == AnonymousPrincipal.ANONYMOUS) {
                return false;
            }
            return true;
        }
    }
}

