/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.apex;

import java.io.Closeable;
import java.io.IOException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.authentication.Authenticator;
import oracle.dbtools.rt.authentication.AuthenticatorBase;
import oracle.dbtools.rt.authentication.Principals;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

@Service(provides={Authenticator.class})
public class ApexAuthenticator
extends AuthenticatorBase {
    private static final String VERIFY = "declare\ntype        t_roles_array is table of varchar2(4000);\nroles_array t_roles_array;\nroles varchar2(32767) := '';\nbegin\n if wwv_flow_listener.authenticate(:tenant_id,:user_id,:password) then \n  select column_value\n   bulk collect into roles_array\n   from table(wwv_flow_listener.get_workspace_user_groups(:tenant_id,:user_id));\n  for role in 1 .. roles_array.count loop\n   roles := roles || roles_array(role) || ', ';\n  end loop;\n else\n  roles := null;\n end if;\n :roles := roles;\nend;\n";
    private static final Statement VERIFY_STMT = StatementBuilder.call().append((CharSequence)"declare\ntype        t_roles_array is table of varchar2(4000);\nroles_array t_roles_array;\nroles varchar2(32767) := '';\nbegin\n if wwv_flow_listener.authenticate(:tenant_id,:user_id,:password) then \n  select column_value\n   bulk collect into roles_array\n   from table(wwv_flow_listener.get_workspace_user_groups(:tenant_id,:user_id));\n  for role in 1 .. roles_array.count loop\n   roles := roles || roles_array(role) || ', ';\n  end loop;\n else\n  roles := null;\n end if;\n :roles := roles;\nend;\n").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("user_id", String.class, ParameterAccess.IN).parameter("password", String.class, ParameterAccess.IN).parameter("roles", String.class, ParameterAccess.OUT).build();

    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        NameCallback n = new NameCallback("username");
        PasswordCallback p = new PasswordCallback("password", false);
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        Callback[] callbacks = new Callback[]{n, p, cp};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        String name = n.getName();
        CompoundPrincipal requestPrincipal = cp.getPrincipal();
        char[] pwd = p.getPassword();
        if (name != null && requestPrincipal != null && pwd != null) {
            JDBCCall call;
            JDBCTransaction txn;
            block8: {
                List<Principal> list;
                String password = new String(pwd);
                TenantPrincipal tenant = TenantPrincipal.tenant((Principal)requestPrincipal);
                long tenantId = TenantPrincipal.id(tenant);
                JDBCPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(requestPrincipal);
                txn = null;
                call = null;
                try {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("tenant_id", tenantId);
                    parameters.put("user_id", name.toUpperCase());
                    parameters.put("password", password);
                    txn = this.jdbc().transaction((Principal)apexListener);
                    call = this.jdbc().call((Transaction)txn, VERIFY_STMT);
                    call.bind(parameters);
                    Map results = call.execute();
                    String result = (String)results.get("roles");
                    if (result == null) break block8;
                    String[] roles = Text.commaDelimited((String)result);
                    list = this.principals(Principals.principals(name, roles));
                }
                catch (SQLException e) {
                    try {
                        throw JDBCException.wrap((SQLException)e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new Closeable[]{call, txn});
                        throw throwable;
                    }
                }
                Closeables.close((Object[])new Closeable[]{call, txn});
                return list;
            }
            Closeables.close((Object[])new Closeable[]{call, txn});
        }
        return null;
    }

    private JDBCCallProvider jdbc() {
        return (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
    }
}

