/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.authentication.HeaderCallback;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.web.RequestEntity;

public abstract class BaseHandler
implements CallbackHandler {
    protected final RequestEntity request;
    private final String username;
    private final char[] password;

    protected BaseHandler(RequestEntity request, Pair<String, char[]> credentials) {
        this.request = request;
        if (credentials == null) {
            this.username = null;
            this.password = null;
        } else {
            this.username = (String)credentials.first();
            this.password = (char[])credentials.second();
        }
    }

    @Override
    public final void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            this.handle(callback);
        }
    }

    protected void handle(Callback callback) {
        if (callback instanceof NameCallback && this.username != null) {
            NameCallback name = (NameCallback)callback;
            name.setName(this.username);
        } else if (callback instanceof PasswordCallback && this.password != null) {
            PasswordCallback cb = (PasswordCallback)callback;
            cb.setPassword(this.password);
        } else if (callback instanceof HeaderCallback) {
            HeaderCallback cb = (HeaderCallback)callback;
            EntityHeader header = this.request.headers().header(cb.getName());
            if (header != null) {
                cb.setValue(header.value());
            }
        } else if (callback instanceof CompoundPrincipalCallback) {
            CompoundPrincipalCallback cb = (CompoundPrincipalCallback)callback;
            cb.setPrincipal(this.request.principal());
        }
    }
}

