/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.quickdiff.QuickDiffAddin;
import oracle.ide.quickdiff.QuickDiffReference;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.ideimpl.vcs.VCSUtil;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.ColorConstants;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.AbstractFoldingMargin;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchModel;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.ui.SectionView;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;

class QuickDiffMargin
extends AbstractFoldingMargin {
    static final String EDITOR_PROPERTY_QUICKDIFF_MARGIN = "quickdiff-margin";
    static final String EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN = "show-quickdiff-margin";
    private final MouseHoverSupport _hoverSupport;
    private Context _ideContext;
    private DocumentListener _documentListener;
    private PeekListener _peekListener;
    private Timer _updateTimer;
    private SequenceCompareModel _compareModel;
    private CodeEditor _codeEditor;
    private PopupCodeWindow _popupWindow;
    private SequenceCompareDifference _currentDifference;
    private QuickDiffReference _reference;
    private Observer _referenceObserver;
    private Observer _referenceProviderObserver;
    private MouseListener _popupTriggerListener;
    private AncestorListener _ancestorListener;
    private int _minimumDifferenceHeight = 2;
    private boolean _paused;

    public QuickDiffMargin(Context ideContext) {
        this._ideContext = ideContext;
        this.setBackground(UIManager.getColor("window"));
        this._hoverSupport = new MouseHoverSupport((Component)this, 500, false);
        this.setPreferredSize(new Dimension(5, 0));
    }

    @Override
    public void installImpl(BasicEditorPane editor) {
        Timer updateTimer;
        this._updateTimer = updateTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QuickDiffMargin.this.updateQuickDiff();
            }
        });
        this._updateTimer.setRepeats(false);
        this._updateTimer.setCoalesce(true);
        this._documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                QuickDiffMargin.this.restartUpdateTimer();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                QuickDiffMargin.this.restartUpdateTimer();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        this.getDocument().addDocumentListener(this._documentListener);
        this._peekListener = new PeekListener();
        this.addMouseListener(this._peekListener);
        this.addMouseMotionListener(this._peekListener);
        this._hoverSupport.addMouseHoverListener((MouseHoverListener)this._peekListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this._peekListener, 8L);
        this.updateContext();
        this._codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)this.getEditorPane());
        this._referenceObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        this.updateReferenceFromProvider();
        this._referenceProviderObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                QuickDiffMargin.this.updateReferenceFromProvider();
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        QuickDiffAddin.getProviderObservable().addObserver(this._referenceProviderObserver);
        this.getEditorPane().putClientProperty((Object)EDITOR_PROPERTY_QUICKDIFF_MARGIN, (Object)this);
        this.installComponent();
        this.updateMarginVisibility();
        this._popupTriggerListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            private void maybeTriggerPopup(MouseEvent me) {
                if (!me.isPopupTrigger()) {
                    return;
                }
                Context context = new Context(QuickDiffMargin.this._ideContext);
                context.setEvent((EventObject)me);
                CodeEditorGutter.getGutterContextMenu().show(context);
            }
        };
        this.addMouseListener(this._popupTriggerListener);
        this._ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                QuickDiffMargin.this.updateTimerState();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
                QuickDiffMargin.this.updateTimerState();
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        };
        this.addAncestorListener(this._ancestorListener);
    }

    private final void updateReferenceFromProvider() {
        QuickDiffReferenceProvider provider;
        if (this._reference != null) {
            this._reference.deleteObserver(this._referenceObserver);
            this._reference.dispose();
        }
        QuickDiffReference quickDiffReference = this._reference = (provider = this.getProviderForURL(this.getURL())) != null ? provider.createReference(this.getURL()) : null;
        if (this._reference != null) {
            this._reference.addObserver(this._referenceObserver);
        }
    }

    private final QuickDiffReferenceProvider getProviderForURL(URL url) {
        QuickDiffReferenceProvider provider = QuickDiffAddin.getProviderObservable().getProvider();
        return url != null && provider != null && provider.isAvailable(url) ? provider : null;
    }

    private void restartUpdateTimer() {
        if (!this.isVisible()) {
            return;
        }
        if (!EditorProperties.getProperties().getBooleanProperty(EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN)) {
            return;
        }
        if (this._paused) {
            return;
        }
        this._updateTimer.restart();
    }

    private void updateMarginVisibility() {
        this.updateMarginVisibility(EditorProperties.getProperties().getBooleanProperty(EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN));
    }

    private void updateMarginVisibility(boolean showMargin) {
        this.setVisible(showMargin);
        this.updateTimerState();
    }

    private void updateTimerState() {
        if (this.isVisible()) {
            this._updateTimer.start();
        } else {
            this._updateTimer.stop();
            this._compareModel = null;
        }
    }

    private void installComponent() {
        Container leftMargin = (Container)this._codeEditor.getScrollableLeftMargin();
        if (leftMargin instanceof SectionView) {
            leftMargin = ((SectionView)leftMargin).getWrappedComponent();
        }
        if (!(leftMargin.getLayout() instanceof BorderLayout)) {
            return;
        }
        Component center = ((BorderLayout)leftMargin.getLayout()).getLayoutComponent("Center");
        if (center == null) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(center, "Center");
        panel.add((Component)this, "East");
        this.putClientProperty("quickdiff-center-component", panel);
        this.putClientProperty("decorated-center-component", center);
        leftMargin.remove(center);
        leftMargin.add((Component)panel, "Center");
    }

    private void updateContext() {
        if (this._ideContext != null) {
            return;
        }
        this._ideContext = this.getEditorPane() != null ? (Context)this.getEditorPane().getProperty("editor-ide-context") : null;
    }

    @Override
    protected void propertyChangeImpl(PropertyChangeEvent pce) {
        this.updateContext();
        if (pce.getPropertyName().equals(EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN)) {
            this.updateMarginVisibility((Boolean)pce.getNewValue());
        }
    }

    private URL getURL() {
        Node node = this._ideContext != null ? this._ideContext.getNode() : null;
        return node != null ? node.getURL() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuickDiff() {
        URL url = this.getURL();
        if (url == null) {
            return;
        }
        final TextBuffer copyEditorTextBuffer = TextBufferFactory.createTextBuffer();
        this.getDocument().readLock();
        try {
            copyEditorTextBuffer.append(this.getDocument().getTextBuffer().getChars(0, this.getDocument().getLength()));
        }
        catch (ExpiredTextBufferException etbe) {
            return;
        }
        finally {
            this.getDocument().readUnlock();
        }
        final QuickDiffReference reference = this._reference;
        if (reference == null) {
            this._compareModel = null;
            return;
        }
        SwingWorker<CompareModel, Object> task = new SwingWorker<CompareModel, Object>(){

            @Override
            protected CompareModel doInBackground() throws Exception {
                TextCompareContributor contributor1 = reference.getCompareContributor();
                final String type = contributor1.getType();
                TextCompareContributor contributor2 = new TextCompareContributor(){

                    public String getType() {
                        return type;
                    }

                    public TextBuffer getTextBuffer() {
                        return copyEditorTextBuffer;
                    }
                };
                if (contributor1 == null) {
                    return null;
                }
                CompareInvocation invocationContext = new CompareInvocation(Collections.singleton(CompareUtil.getCompareMethodForType((CompareType)CompareType.TEXT)));
                invocationContext.setContextNode(QuickDiffMargin.this._ideContext != null ? QuickDiffMargin.this._ideContext.getNode() : null);
                return CompareUtil.createCompareModel((CompareContributor)contributor1, (CompareContributor)contributor2, (CompareInvocation)invocationContext);
            }

            @Override
            protected void done() {
                try {
                    QuickDiffMargin.this._compareModel = (SequenceCompareModel)this.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QuickDiffMargin.this.repaint();
            }
        };
        task.execute();
    }

    @Override
    public void deinstallImpl(BasicEditorPane editor) {
        if (this._documentListener != null) {
            this.getDocument().removeDocumentListener(this._documentListener);
        }
        this._documentListener = null;
        if (this._peekListener != null) {
            this.removeMouseListener(this._peekListener);
            this.removeMouseMotionListener(this._peekListener);
            this._hoverSupport.removeMouseHoverListener((MouseHoverListener)this._peekListener);
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._peekListener);
        }
        this._peekListener = null;
        if (this._updateTimer != null) {
            this._updateTimer.stop();
        }
        this._updateTimer = null;
        if (this._reference != null) {
            this._reference.deleteObserver(this._referenceObserver);
            this._reference.dispose();
        }
        this._reference = null;
        this._referenceObserver = null;
        QuickDiffAddin.getProviderObservable().deleteObserver(this._referenceProviderObserver);
        this._referenceProviderObserver = null;
        this.getEditorPane().putClientProperty((Object)EDITOR_PROPERTY_QUICKDIFF_MARGIN, null);
        if (this._popupTriggerListener != null) {
            this.removeMouseListener(this._popupTriggerListener);
        }
        this._popupTriggerListener = null;
        if (this._ancestorListener != null) {
            this.removeAncestorListener(this._ancestorListener);
        }
        this._ancestorListener = null;
        this.setVisible(false);
        this.deinstallComponent();
        this._codeEditor = null;
    }

    private void deinstallComponent() {
        Container leftMargin = (Container)this._codeEditor.getScrollableLeftMargin();
        if (leftMargin instanceof SectionView) {
            leftMargin = ((SectionView)leftMargin).getWrappedComponent();
        }
        if (!(leftMargin.getLayout() instanceof BorderLayout)) {
            return;
        }
        Component panel = (Component)this.getClientProperty("quickdiff-center-component");
        Component center = (Component)this.getClientProperty("decorated-center-component");
        if (panel == null || center == null) {
            return;
        }
        if (((BorderLayout)leftMargin.getLayout()).getLayoutComponent("Center") != panel) {
            return;
        }
        leftMargin.remove(panel);
        leftMargin.add(center, "Center");
    }

    @Override
    protected Observer getCodeFoldingObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                QuickDiffMargin.this.repaint();
            }
        };
    }

    @Override
    public void paint(final Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.visitDifferences(new DifferenceVisitor(){

            @Override
            protected void visit(SequenceCompareDifference difference, int y, int height) {
                if (difference == QuickDiffMargin.this._currentDifference) {
                    g.setColor(QuickDiffMargin.this.processColorForMouseOver(QuickDiffMargin.this.getDifferenceColor(difference)));
                } else {
                    g.setColor(QuickDiffMargin.this.getDifferenceColor(difference));
                }
                g.fillRect(0, y + 1, QuickDiffMargin.this.getWidth(), height);
            }
        }, VisitOrder.REVERSE);
    }

    private Color processColorForMouseOver(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        hsb[1] = Math.min(1.0f, hsb[1] * 2.0f);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    private Color getDifferenceColor(SequenceCompareDifference difference) {
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        if (difference.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
            HighlightStyle style = highlightRegistry.lookupStyle("inline-compare-addition");
            return style != null ? style.getBackgroundColor() : ColorConstants.COLOR_ADDED;
        }
        if (difference.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
            HighlightStyle style = highlightRegistry.lookupStyle("inline-compare-deletion");
            return style != null ? style.getBackgroundColor() : ColorConstants.COLOR_REMOVED;
        }
        if (difference.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            HighlightStyle style = highlightRegistry.lookupStyle("inline-compare-update");
            return style != null ? style.getBackgroundColor() : ColorConstants.COLOR_CHANGED;
        }
        return Color.BLACK;
    }

    @Override
    protected final void updateFontMetrics() {
        super.updateFontMetrics();
        this._minimumDifferenceHeight = Math.max(2, this.getFontMetrics().getHeight() / 4);
    }

    private void visitDifferences(DifferenceVisitor visitor, VisitOrder order) {
        if (this._compareModel == null) {
            return;
        }
        List<SequenceCompareDifference> differences = Arrays.asList(this._compareModel.getDifferenceBlocks());
        if (order == VisitOrder.NATURAL) {
            // empty if block
        }
        if (order == VisitOrder.REVERSE) {
            differences = new ArrayList<SequenceCompareDifference>(differences);
            Collections.reverse(differences);
        }
        int lineHeight = this.getFontMetrics().getHeight();
        for (SequenceCompareDifference difference : differences) {
            int startLine = this.getVirtualLineForReal(difference.getSecondStart());
            int endLine = this.getVirtualLineForReal(difference.getSecondStart() + difference.getSecondLength());
            int y = startLine * lineHeight;
            int height = Math.max(this._minimumDifferenceHeight, (endLine - startLine) * lineHeight);
            visitor.visit(difference, y, height);
            if (!visitor.isExit()) continue;
            return;
        }
    }

    private void showOrHidePopupWindow(MouseEvent me) {
        if (this._compareModel == null) {
            this.hidePopupWindow();
            return;
        }
        if (this._currentDifference == null) {
            this.hidePopupWindow();
            return;
        }
        if (me == null) {
            return;
        }
        PopupCodeWindow popupWindow = this.getPopupWindow();
        SequenceCompareModel compareModel = (SequenceCompareModel)this._compareModel.createInstance((CompareDifference[])new SequenceCompareDifference[]{this._currentDifference});
        PatchEntry patchEntry = PatchEngine.createPatchEntry((SequenceCompareModel)compareModel);
        PatchModel patchModel = new PatchModel();
        patchModel.addEntry(patchEntry);
        for (PatchHunk patchHunk : patchEntry.getHunks()) {
            for (PatchHunkLine patchHunkLine : patchHunk.getLines()) {
                if (this.isEqualWhenIgnoringWhitespace(this._currentDifference)) {
                    patchHunkLine.setLineData(this.replaceWhitespaceCharsForVisible(patchHunkLine.getLineData()));
                }
                patchHunkLine.setLineData(' ' + patchHunkLine.getLineData());
            }
        }
        PatchFormat patchFormat = new PatchFormat();
        TextCompareContributor referenceContributor = (TextCompareContributor)this._compareModel.getContributor(ContributorKind.FIRST);
        if (referenceContributor instanceof InputStreamTextContributor) {
            patchFormat.setEncoding(((InputStreamTextContributor)referenceContributor).getStreamEncoding());
        }
        String patch = patchFormat.format(patchModel);
        popupWindow.setText(this.trimEndOfLineChars(patch.substring(patch.indexOf("@@ "))));
        popupWindow.setBackground(this.getDifferenceColor(this._currentDifference));
        Component c = (Component)this.getEditorPane().getProperty("code-folding-margin");
        if (c == null || !c.isVisible()) {
            c = this;
        }
        Point marginPos = c.getLocationOnScreen();
        Insets popupInsets = popupWindow.getPopupInsets();
        int xPos = marginPos.x + c.getWidth() - popupInsets.left;
        int yPos = marginPos.y + Math.max(this.getEditorPane().getVisibleRect().y, this.getYCoordinateFromLine(this._currentDifference.getSecondStart())) - popupInsets.top;
        popupWindow.setLocation(xPos, yPos);
        Dimension contentSize = popupWindow.getContentPane().getPreferredSize();
        popupWindow.setSize(contentSize.width, contentSize.height);
        popupWindow.validate();
        popupWindow.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqualWhenIgnoringWhitespace(SequenceCompareDifference difference) {
        TextCompareContributor referenceContributor = (TextCompareContributor)this._compareModel.getContributor(ContributorKind.FIRST);
        TextCompareContributor copyEditorContributor = (TextCompareContributor)this._compareModel.getContributor(ContributorKind.SECOND);
        referenceContributor.setIgnoreWhitespace(true);
        copyEditorContributor.setIgnoreWhitespace(true);
        if (difference.getFirstLength() != difference.getSecondLength()) {
            return false;
        }
        referenceContributor.getTextBuffer().readLock();
        copyEditorContributor.getTextBuffer().readLock();
        try {
            int i = difference.getFirstStart();
            int j = difference.getSecondStart();
            while (i < difference.getFirstStart() + difference.getFirstLength()) {
                if (!referenceContributor.equal(i, (SequenceCompareContributor)copyEditorContributor, j)) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
                ++j;
            }
        }
        finally {
            referenceContributor.getTextBuffer().readUnlock();
            copyEditorContributor.getTextBuffer().readUnlock();
        }
        return true;
    }

    private String replaceWhitespaceCharsForVisible(String s) {
        s = s.replace('\t', '\u00bb');
        s = s.replace(' ', '\u00b7');
        return s + '\u00b6';
    }

    private String trimEndOfLineChars(String s) {
        int length;
        String endOfLineChars = "\r\f\n";
        for (length = s.length(); length > 0 && endOfLineChars.indexOf(s.charAt(length - 1)) >= 0; --length) {
        }
        return length >= s.length() ? s : s.substring(0, length);
    }

    private String getDifferenceTextFromBuffer(SequenceCompareDifference difference, ContributorKind contributorKind, TextBuffer textBuffer) {
        int[] offsets = this.getDifferenceOffsets(difference, contributorKind, textBuffer);
        return offsets != null ? textBuffer.getString(offsets[0], offsets[1] - offsets[0]) : null;
    }

    private int[] getDifferenceOffsets(SequenceCompareDifference difference, ContributorKind contributorKind, TextBuffer textBuffer) {
        int startLine = difference.getStart(contributorKind);
        int endLine = startLine + difference.getLength(contributorKind) - 1;
        if (endLine < startLine) {
            return null;
        }
        int startOffset = textBuffer.getLineMap().getLineStartOffset(startLine);
        int endOffset = textBuffer.getLineMap().getLineEndOffset(endLine);
        if ((endOffset = Math.min(endOffset, textBuffer.getLength())) < startOffset) {
            return null;
        }
        return new int[]{startOffset, endOffset};
    }

    private void hidePopupWindow() {
        if (this._popupWindow != null && this._popupWindow.isVisible()) {
            this._popupWindow.setVisible(false);
        }
    }

    private int getYCoordinateFromLine(int line) {
        BasicEditorPane editor = this.getEditorPane();
        BasicDocument document = this.getDocument();
        LineMap lineMap = document.getLineMap();
        try {
            int offset = Math.max(0, Math.min(document.getLength(), lineMap.getLineStartOffset(line)));
            Rectangle offsetRect = editor.modelToView(offset);
            return offsetRect.y;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private SequenceCompareDifference getFirstDifferenceAtY(final int y) {
        final SequenceCompareDifference[] difference = new SequenceCompareDifference[1];
        this.visitDifferences(new DifferenceVisitor(){

            @Override
            protected void visit(SequenceCompareDifference difference2, int y2, int height) {
                if (y >= y2 && y <= y2 + height) {
                    difference[0] = difference2;
                    this.exit();
                }
            }
        }, VisitOrder.NATURAL);
        return difference[0];
    }

    Action[] getEditActions(MouseEvent me) {
        SequenceCompareDifference difference = this.getFirstDifferenceAtY(me.getY());
        if (difference == null) {
            return null;
        }
        ArrayList<BaseEditAction> editActions = new ArrayList<BaseEditAction>();
        if (difference.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
            editActions.add(new DeleteAction(difference));
        }
        if (difference.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
            editActions.add(new InsertAction(difference));
        }
        if (difference.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            editActions.add(new RevertAction(difference));
        }
        return editActions.toArray(new Action[0]);
    }

    private void updateCurrentDifference(MouseEvent me) {
        SequenceCompareDifference difference = me == null ? null : this.getFirstDifferenceAtY(me.getY());
        if (difference != this._currentDifference) {
            this._currentDifference = difference;
            this.repaint();
        }
    }

    private PopupCodeWindow getPopupWindow() {
        if (this._popupWindow == null) {
            BasicEditorPane editorPane = this.getEditorPane();
            this._popupWindow = new PopupCodeWindow(editorPane);
        }
        return this._popupWindow;
    }

    private static final class PopupCodeWindow
    extends JWindow {
        private JScrollPane _popupScrollPane;
        private BasicEditorPane _popupEditorPane;

        public PopupCodeWindow(BasicEditorPane editorPane) {
            super(SwingUtilities.getWindowAncestor((Component)editorPane));
            this.initializeFrom(editorPane);
        }

        public void setText(String text) {
            this._popupEditorPane.setText(text);
        }

        public String getText() {
            return this._popupEditorPane.getText();
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            this._popupScrollPane.setBackground(color);
        }

        public Insets getPopupInsets() {
            Insets ret = super.getInsets();
            for (Object c = this._popupEditorPane; c != this; c = c.getParent()) {
                Insets insets = c.getInsets();
                ret.top += insets.top;
                ret.left += insets.left;
                ret.bottom += insets.bottom;
                ret.right += insets.right;
            }
            return ret;
        }

        private void initializeFrom(BasicEditorPane editorPane) {
            BasicDocument document = (BasicDocument)editorPane.getDocument();
            LanguageSupport support = document.getLanguageSupport();
            LanguageSupport popupSupport = LanguageModule.createSupportForFileType(support.getClass());
            BasicDocument popupDocument = new BasicDocument();
            popupDocument.setLanguageSupport(popupSupport);
            this._popupEditorPane = new BasicEditorPane();
            this._popupEditorPane.setDocument((Document)popupDocument);
            this._popupEditorPane.setBorder(BorderFactory.createEmptyBorder());
            this._popupEditorPane.setOpaque(false);
            Border outerBorder = UIManager.getBorder("ToolTip.border");
            this._popupScrollPane = new JScrollPane((Component)this._popupEditorPane);
            this._popupScrollPane.setBorder(outerBorder);
            this._popupScrollPane.setBackground(UIManager.getColor("ToolTip.background"));
            Insets editorInsets = editorPane.getInsets();
            Border innerBorder = BorderFactory.createEmptyBorder(0, editorInsets.left, 0, editorInsets.right);
            this._popupScrollPane.setViewportBorder(innerBorder);
            this._popupScrollPane.getViewport().setOpaque(false);
            this.getContentPane().add(this._popupScrollPane);
            this.setFocusableWindowState(false);
        }
    }

    private class PeekListener
    extends MouseInputAdapter
    implements MouseHoverListener,
    AWTEventListener {
        private PeekListener() {
        }

        public void mouseHovered(MouseEvent event) {
            QuickDiffMargin.this.showOrHidePopupWindow(event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            QuickDiffMargin.this.updateCurrentDifference(event);
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            QuickDiffMargin.this.updateCurrentDifference(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            QuickDiffMargin.this.updateCurrentDifference(null);
            QuickDiffMargin.this.showOrHidePopupWindow(null);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (!QuickDiffMargin.this.isShowing()) {
                return;
            }
        }
    }

    private class RevertAction
    extends BaseEditAction {
        RevertAction(SequenceCompareDifference difference) {
            super(QuickDiffArb.getString(7), difference);
        }
    }

    private class InsertAction
    extends BaseEditAction {
        InsertAction(SequenceCompareDifference difference) {
            super(QuickDiffArb.getString(6), difference);
        }
    }

    private class DeleteAction
    extends BaseEditAction {
        DeleteAction(SequenceCompareDifference difference) {
            super(QuickDiffArb.getString(5), difference);
        }
    }

    private abstract class BaseEditAction
    extends AbstractAction {
        private final SequenceCompareDifference _difference;

        BaseEditAction(String name, SequenceCompareDifference difference) {
            super(name);
            this._difference = difference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            int editorStartOffset;
            int[] editorOffsets;
            int[] referenceOffsets;
            URL url = QuickDiffMargin.this.getURL();
            if (url != null && URLFileSystem.isReadOnly((URL)url) && !VCSUtil.checkOutOnUndoStack((Node)QuickDiffMargin.this._ideContext.getNode())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            TextBuffer referenceTextBuffer = ((TextCompareContributor)QuickDiffMargin.this._compareModel.getContributor(ContributorKind.FIRST)).getTextBuffer();
            TextBuffer editorTextBuffer = QuickDiffMargin.this.getDocument().getTextBuffer();
            referenceTextBuffer.readLock();
            editorTextBuffer.readLock();
            try {
                referenceOffsets = QuickDiffMargin.this.getDifferenceOffsets(this._difference, ContributorKind.FIRST, referenceTextBuffer);
                editorOffsets = QuickDiffMargin.this.getDifferenceOffsets(this._difference, ContributorKind.SECOND, editorTextBuffer);
                editorStartOffset = editorTextBuffer.getLineMap().getLineStartOffset(this._difference.getSecondStart());
            }
            finally {
                referenceTextBuffer.readUnlock();
                editorTextBuffer.readUnlock();
            }
            QuickDiffMargin.this._paused = true;
            QuickDiffMargin.this.getEditorPane().beginEdit(new EditDescriptor((String)this.getValue("Name")));
            try {
                if (editorOffsets != null) {
                    editorTextBuffer.remove(editorOffsets[0], editorOffsets[1] - editorOffsets[0]);
                }
                if (referenceOffsets != null) {
                    editorTextBuffer.insert(editorStartOffset, referenceTextBuffer.getChars(referenceOffsets[0], referenceOffsets[1] - referenceOffsets[0]));
                }
            }
            finally {
                QuickDiffMargin.this.getEditorPane().endEdit(false, null);
                QuickDiffMargin.this._paused = false;
                QuickDiffMargin.this.restartUpdateTimer();
            }
        }
    }

    private static enum VisitOrder {
        NATURAL,
        REVERSE;

    }

    private abstract class DifferenceVisitor {
        private boolean _exit;

        private DifferenceVisitor() {
        }

        protected abstract void visit(SequenceCompareDifference var1, int var2, int var3);

        protected final void exit() {
            this._exit = true;
        }

        boolean isExit() {
            return this._exit;
        }
    }
}

