/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class SearchSectionUI
extends PaletteSectionUI {
    public SearchSectionUI(JPanel midPanel, String viewState, PaletteSection section, PaletteGroupUI groupUI) {
        super(midPanel, viewState, section, groupUI);
    }

    @Override
    protected void initItems() {
        Collection<PaletteAugmentedItem> augItems = ((PaletteAugmentedSection)this.paletteSection).getAugmentedItems(false);
        if (augItems != null) {
            if (augItems.size() > 0) {
                for (PaletteAugmentedItem augItem : augItems) {
                    PaletteItem paletteItem = augItem.getPaletteItem();
                    PaletteItemUI item = new PaletteItemUI(paletteItem, this, this.showState, augItem.getPageName(), augItem.getGroupName());
                    this.itemUI.add(item);
                    this.midPanel.add(item);
                }
            } else {
                JPanel noResultsPanel = new JPanel();
                noResultsPanel.setLayout(new BorderLayout());
                JLabel noResultsLabel = new JLabel();
                if (Themes.isThemed()) {
                    ThemeProperties themeProperties = Themes.getActiveTheme().getStateProperties("paletteitem", "disabled");
                    noResultsPanel.setBackground(themeProperties.getColor("background"));
                    noResultsLabel.setForeground(themeProperties.getColor("foreground"));
                }
                noResultsLabel.setText(PaletteArb.getString(56));
                noResultsLabel.setOpaque(false);
                noResultsLabel.setEnabled(false);
                noResultsLabel.setBorder(BorderFactory.createEmptyBorder(16, 24, 16, 24));
                noResultsPanel.add((Component)noResultsLabel, "Center");
                this.midPanel.add(noResultsPanel);
            }
        }
    }
}

