/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class PaletteGroupUI
extends JPanel
implements MouseListener,
KeyListener {
    protected PaletteGroup paletteGroup = null;
    protected CenterPanel midPanel = new CenterPanel();
    protected JScrollPane scrollPane = null;
    protected String showState = null;
    protected List<PaletteSectionUI> sectionUI = new ArrayList<PaletteSectionUI>();
    protected boolean _tryPopupInMousePressed = false;
    private PaletteControllerUI paletteController = PaletteControllerUI.getInstance();
    int cellHeight = 0;

    public PaletteGroupUI(String showState) {
        this.setMidPanelLayout(showState);
        this.midPanel.addMouseListener(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.midPanel, 20, 30);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.scrollPane, "Center");
        this.addKeyListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int singleItemHeight = PaletteGroupUI.this.getSingleItemHeight();
                int itemsDisplayed = (int)Math.ceil(1.0 * (double)PaletteGroupUI.this.scrollPane.getHeight() / (double)singleItemHeight);
                int blockIncrement = (itemsDisplayed - 1) * singleItemHeight;
                PaletteGroupUI.this.scrollPane.getVerticalScrollBar().setBlockIncrement(blockIncrement);
            }
        });
    }

    protected void initialize() {
        if (this.paletteGroup == null) {
            return;
        }
        this.sectionUI.clear();
        Collection<PaletteSection> paletteSections = this.paletteGroup.getSections();
        for (PaletteSection section : paletteSections) {
            this.sectionUI.add(new PaletteSectionUI(this.midPanel, this.showState, section, this));
        }
    }

    public void setData(PaletteGroup paletteGroup) {
        this.paletteGroup = paletteGroup;
        this.midPanel.removeAll();
        this.midPanel.revalidate();
        this.midPanel.repaint();
        this.initialize();
    }

    public PaletteGroup getPaletteGroup() {
        return this.paletteGroup;
    }

    public void toggleView(String newViewState) {
        if (newViewState.equals(this.showState)) {
            return;
        }
        this.setMidPanelLayout(newViewState);
        for (PaletteSectionUI sectUI : this.sectionUI) {
            sectUI.setShowState(newViewState);
        }
    }

    public List<PaletteItemUI> getAllPaletteItemUIs() {
        ArrayList<PaletteItemUI> paletteItems = new ArrayList<PaletteItemUI>();
        for (PaletteSectionUI nextSectionUI : this.sectionUI) {
            paletteItems.addAll(nextSectionUI.getPaletteItems());
        }
        return paletteItems;
    }

    private int getSingleItemHeight() {
        List<PaletteItemUI> allItems = this.getAllPaletteItemUIs();
        if (allItems.size() == 0) {
            return 20;
        }
        if (this.cellHeight == 0) {
            this.cellHeight = allItems.get(0).getHeight();
        }
        return this.cellHeight;
    }

    private void setMidPanelLayout(String showState) {
        this.showState = showState;
        if (showState.equals("list")) {
            this.midPanel.setView(ViewType.LIST_VIEW);
        } else {
            this.midPanel.setView(ViewType.ICON_VIEW);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (PaletteSectionUI section : this.sectionUI) {
            section.showAsUnselected();
        }
        this.requestFocusInWindow();
        this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
        this.paletteController.setSelectedWindowUI(this);
        boolean bl = this._tryPopupInMousePressed = e.isPopupTrigger();
        if (this._tryPopupInMousePressed) {
            this.paletteController.unSelectSelectedItem(true);
            this.tryPopup(e);
        }
    }

    private void tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.paletteController.tryPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._tryPopupInMousePressed && !e.isPopupTrigger() && e.getButton() != 2) {
            this.paletteController.setSelectedWindowUI(this);
        }
        this.tryPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.handleEscapeKey();
        }
        if (e.getKeyCode() == 10) {
            this.handleEnterKey();
        }
    }

    private void handleEscapeKey() {
        PalettePages palette1Pages;
        PaletteItem paletteItem;
        if (this.paletteController.getStickyMode()) {
            this.paletteController.setStickyMode(false);
        }
        if ((paletteItem = this.paletteController.getSelectedItem()) != null && paletteItem.getProviderId().equalsIgnoreCase(PaletteArb.getString(5)) && (palette1Pages = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getPalette1ProviderPages()) != null) {
            Palette1Provider prov = (Palette1Provider)((Object)palette1Pages);
            prov.escapeKeyPressed(paletteItem);
        }
        this.paletteController.unSelectSelectedItem(true);
        this.midPanel.removeAll();
        this.midPanel.revalidate();
        this.midPanel.repaint();
        this.initialize();
    }

    private void handleEnterKey() {
        PaletteSectionUI section;
        PaletteItemUI itemUI = null;
        Collection<PaletteSection> paletteSections = this.paletteGroup.getSections();
        Iterator<PaletteSectionUI> i$ = this.sectionUI.iterator();
        while (i$.hasNext() && (itemUI = (section = i$.next()).getItemWithFocus()) == null) {
        }
        if (itemUI != null) {
            this.paletteController.setSelectedWindowUI(itemUI, "PALETTE2_ITEM_DEFAULTCREATE");
        } else {
            itemUI = this.paletteController.getSelectedItemUI();
            if (itemUI != null) {
                this.paletteController.fireItemSelected("PALETTE2_ITEM_DEFAULTCREATE");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected class CenterPanel
    extends JPanel {
        private final Set<FocusListener> focusListeners = new HashSet<FocusListener>();
        private ViewType currentView = null;

        public CenterPanel() {
            this.initColors();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (ViewType.ICON_VIEW.equals((Object)this.currentView)) {
                int newHeightOfIconized;
                int totalWidthNeeded = 0;
                float heightFudgeFactor = 1.1f;
                for (PaletteSectionUI paletteSectionUI : PaletteGroupUI.this.sectionUI) {
                    if (paletteSectionUI.sectionSeparator != null) {
                        totalWidthNeeded = (int)((double)totalWidthNeeded + paletteSectionUI.sectionSeparator.getPreferredSize().getWidth());
                    }
                    List<PaletteItemUI> paletteItems = paletteSectionUI.getPaletteItems();
                    PaletteItemUI firstPaletteItemUI = null;
                    Iterator paletteItemUIIterator = paletteItems.iterator();
                    if (!paletteItemUIIterator.hasNext()) continue;
                    firstPaletteItemUI = (PaletteItemUI)paletteItemUIIterator.next();
                    totalWidthNeeded += paletteItems.size() * firstPaletteItemUI.getHeight();
                }
                int numberOfColumnsNeeded = PaletteGroupUI.this.scrollPane.getWidth() != 0 ? (int)Math.ceil((double)totalWidthNeeded * (double)1.1f / (double)PaletteGroupUI.this.scrollPane.getWidth()) : 0;
                size.height = newHeightOfIconized = numberOfColumnsNeeded * size.height;
                size.width = 0;
            }
            return size;
        }

        @Override
        public synchronized void addFocusListener(FocusListener l) {
            this.focusListeners.add(l);
            super.addFocusListener(l);
            this.addFocusListenerToComponents(l, null);
        }

        private void initColors() {
            if (Themes.isThemed()) {
                ThemeProperties tp = Themes.getActiveTheme().getStateProperties("palettewindow", "enabled");
                this.setBackground(tp.getColor("background"));
            }
        }

        void addFocusListener(FocusListener l, Component source) {
            this.addFocusListener(l);
            this.addFocusListenerToComponents(l, source);
        }

        private void addFocusListenerToComponents(FocusListener l, Component source) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof PaletteItemUI) || c == source) continue;
                PaletteItemUI paletteItemUI = (PaletteItemUI)c;
                paletteItemUI.addFocusListenerWithoutPropagationToParent(l);
            }
        }

        @Override
        public Component add(Component comp) {
            this.addFocusListenersToActivateAccordionHeader(comp);
            return super.add(comp);
        }

        private void addFocusListenersToActivateAccordionHeader(Component addedComponent) {
            for (FocusListener l : this.focusListeners) {
                addedComponent.addFocusListener(l);
            }
        }

        private void setView(ViewType viewType) {
            if (viewType.equals((Object)ViewType.LIST_VIEW)) {
                PaletteGroupUI.this.midPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
                this.currentView = ViewType.LIST_VIEW;
            } else {
                PaletteGroupUI.this.midPanel.setLayout(new FlowLayout(0));
                this.currentView = ViewType.ICON_VIEW;
            }
        }
    }

    private static enum ViewType {
        LIST_VIEW,
        ICON_VIEW;

    }
}

