/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import oracle.ide.docking.BaseDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.view.MultiManager;
import oracle.ide.view.View;
import oracle.ideimpl.palette2.GroupDockable;
import oracle.ideimpl.palette2.InactiveDockable;
import oracle.ideimpl.palette2.MyComponentsDockable;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.ideimpl.palette2.SearchDockable;
import oracle.javatools.jndi.Names;

public class PaletteDockableFactory
implements BaseDockableFactory {
    public static final String VIEW_TYPE = "PALETTEFACTORY";
    private static final PaletteDockableFactory _singleton = new PaletteDockableFactory();
    private static SearchDockable searchDockable;
    private static InactiveDockable inactiveDockable;
    private static InactiveDockable loadingPaletteDockable;
    final Map<String, View> groupViews = new HashMap<String, View>();

    public static PaletteDockableFactory getInstance() {
        return _singleton;
    }

    public void install() {
        DockingParam dockingParam = new DockingParam();
        MultiManager mgr = (MultiManager)Names.lookup((Context)Names.newInitialContext(), (String)"ide/inspector-manager");
        ViewId viewId = mgr.getDefaultViewId();
        DockStation ds = DockStation.getDockStation();
        Dockable inspectorDockable = ds.findDockable(viewId);
        if (inspectorDockable != null) {
            dockingParam.setPosition(inspectorDockable, 2, 1);
        } else {
            dockingParam.setPosition(1);
        }
        DockStation.getDockStation().dock((Dockable)PaletteWindowImpl.getInstance(), dockingParam);
    }

    public View lookupView(ViewId viewId) {
        String viewName = viewId.getName();
        if (viewName == null || "PALETTE".equals(viewName)) {
            return PaletteWindowImpl.getInstance();
        }
        if ("PALETTE2_SEARCH".equals(viewName)) {
            if (searchDockable == null) {
                searchDockable = new SearchDockable();
            }
            return this.addForHideDockables(viewName, (View)searchDockable);
        }
        if (viewName.startsWith(PaletteArb.getString(8))) {
            return this.addForHideDockables(viewName, (View)new MyComponentsDockable(viewName));
        }
        if (viewName.startsWith(PaletteArb.getString(53))) {
            if (inactiveDockable == null) {
                inactiveDockable = new InactiveDockable(viewName);
                inactiveDockable.setDisplayMessage(PaletteArb.getString(53));
            }
            return this.addForHideDockables(viewName, (View)inactiveDockable);
        }
        if (viewName.startsWith(PaletteArb.getString(62))) {
            if (loadingPaletteDockable == null) {
                loadingPaletteDockable = new InactiveDockable(viewName);
                loadingPaletteDockable.setDisplayMessage(PaletteArb.getString(62));
            }
            return this.addForHideDockables(viewName, (View)loadingPaletteDockable);
        }
        return this.addForHideDockables(viewName, (View)new GroupDockable(viewName));
    }

    private View addForHideDockables(String viewName, View view) {
        this.groupViews.put(viewName, view);
        return view;
    }

    public Dockable getDockable(ViewId viewId) {
        return (Dockable)this.lookupView(viewId);
    }

    public void hideDockables() {
        PaletteWindowImpl w = (PaletteWindowImpl)PaletteWindowImpl.getInstance();
        for (View view : this.groupViews.values()) {
            try {
                w.hide(view);
            }
            catch (Exception ignored) {}
        }
    }
}

