/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetDialog;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.MyComponentsSectionUI;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;

public class MyComponentsGroupUI
extends PaletteGroupUI
implements DropTargetListener {
    private JTextArea msgTextArea = null;
    private DropTarget dropTarget = null;

    public MyComponentsGroupUI(String vwState) {
        super(vwState);
    }

    @Override
    protected void initialize() {
        if (this.paletteGroup != null) {
            this.sectionUI.clear();
            if (this.isGroupEmpty()) {
                this.msgTextArea = this.getMessageTextArea();
                this.msgTextArea.addMouseListener(this);
                this.midPanel.add(this.msgTextArea);
            } else {
                this.msgTextArea = null;
                Collection<PaletteSection> paletteSections = this.paletteGroup.getSections();
                for (PaletteSection section : paletteSections) {
                    MyComponentsSectionUI sectUI = new MyComponentsSectionUI(this.midPanel, this.showState, section, this);
                    this.sectionUI.add(sectUI);
                }
            }
        }
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
        this.paletteGroup = paletteGroup;
        if (this.dropTarget == null && (paletteGroup.getName().equals(PaletteArb.getString(14)) || paletteGroup.getName().equals(PaletteArb.getString(10)))) {
            this.dropTarget = new DropTarget(this, 1, this);
        }
        this.midPanel.removeAll();
        this.midPanel.revalidate();
        this.midPanel.repaint();
        this.initialize();
    }

    protected boolean isGroupEmpty() {
        Collection<PaletteSection> sections = this.paletteGroup.getSections();
        return sections.isEmpty();
    }

    protected JTextArea getMessageTextArea() {
        boolean dropTarget = false;
        msgDisplayText textArea = null;
        String displayText = null;
        String name = this.paletteGroup.getName();
        if (name.equals(PaletteArb.getString(10))) {
            dropTarget = true;
            displayText = PaletteArb.getString(16);
        } else if (name.equals(PaletteArb.getString(14))) {
            dropTarget = true;
            displayText = String.format("%s\n\n%s\n\n%s\n\n%s", String.valueOf(PaletteArb.getString(18)), String.valueOf(PaletteArb.getString(19)), String.valueOf(PaletteArb.getString(20)), String.valueOf(PaletteArb.getString(21)));
        } else if (name.equals(PaletteArb.getString(12))) {
            displayText = PaletteArb.getString(17);
        }
        if (displayText != null) {
            textArea = new msgDisplayText(displayText);
            if (dropTarget) {
                new DropTarget(textArea, 1, this);
            }
        }
        return textArea;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.acceptOrReject(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.acceptOrReject(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.acceptOrReject(dtde);
    }

    private void acceptOrReject(DropTargetDragEvent dtde) {
        boolean accept = false;
        if (this.paletteGroup != null) {
            if (this.paletteGroup.getName().equals(PaletteArb.getString(14))) {
                if ((dtde.getDropAction() & 3) > 0 && (dtde.isDataFlavorSupported(DataFlavor.stringFlavor) || dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR))) {
                    accept = true;
                }
            } else if (this.paletteGroup.getName().equals(PaletteArb.getString(10)) && dtde.getDropAction() == 1 && dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                accept = true;
            }
        }
        if (accept) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean accept = false;
        String snippet = null;
        if (this.paletteGroup != null) {
            if (this.paletteGroup.getName().equals(PaletteArb.getString(14))) {
                if ((dtde.getDropAction() & 3) > 0) {
                    if (dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                        try {
                            Transferable transferable = dtde.getTransferable();
                            Object data = transferable.getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                            if (data != null) {
                                MyComponentsCodeSnippetItem pI = (MyComponentsCodeSnippetItem)data;
                                Point dropPoint = dtde.getLocation();
                                String[] locs = this.determineInsertLocation(dropPoint);
                                MyComponentsCodeSnippetItem item = new MyComponentsCodeSnippetItem(pI.getName(), pI.getIconURL(), (String)pI.getData("codeSnippet"));
                                MyComponentsPages.getInstance().removeItem(14, pI);
                                MyComponentsPages.getInstance().insertCodeSnippet(item, locs[0], locs[1], true);
                                accept = true;
                            }
                        }
                        catch (Exception e) {}
                    } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            Transferable transferable = dtde.getTransferable();
                            Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                            snippet = data.toString();
                            if (snippet != null && snippet.length() > 0) {
                                accept = true;
                                this.showCodeSnippetDialog(snippet);
                            }
                        }
                        catch (Exception e) {}
                    }
                }
            } else if (this.paletteGroup.getName().equals(PaletteArb.getString(10)) && dtde.getDropAction() == 1 && dtde.isDataFlavorSupported(PaletteItem.PALETTE_ITEM_FLAVOR)) {
                try {
                    Transferable transferable = dtde.getTransferable();
                    Object data = transferable.getTransferData(PaletteItem.PALETTE_ITEM_FLAVOR);
                    if (data != null) {
                        PaletteItem item = (PaletteItem)data;
                        Point dropPoint = dtde.getLocation();
                        String[] locs = this.determineInsertLocation(dropPoint);
                        String[] augText = this.getAugmentedText(item);
                        MyComponentsPages.getInstance().removeItem(10, item);
                        MyComponentsPages.getInstance().insertFavorites(item, augText[0], augText[1], locs[0], locs[1], true);
                        accept = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (accept) {
            dtde.acceptDrop(1);
            dtde.dropComplete(true);
        } else {
            dtde.rejectDrop();
        }
    }

    protected void showCodeSnippetDialog(String snippet) {
        MyComponentsCodeSnippetDialog dlg = new MyComponentsCodeSnippetDialog();
        String sectionName = PaletteControllerUI.getInstance().getCurrentSectionName();
        dlg.invoke(this.paletteGroup, sectionName, null, snippet);
    }

    private String[] determineInsertLocation(Point dropPoint) {
        String section = "";
        String item = "";
        Component comp = this.midPanel.getComponentAt(dropPoint);
        if (comp != null) {
            String name = comp.getClass().getName();
            if (name.equals(PaletteItemUI.class.getName())) {
                PaletteItemUI pItem = (PaletteItemUI)comp;
                if (pItem != null) {
                    item = pItem.getPaletteItem().getItemId();
                    section = pItem.getPaletteSectionUI().getPaletteSection().getName();
                }
            } else if (name.startsWith(PaletteSectionUI.class.getName())) {
                JLabel pLabel = (JLabel)comp;
                if (pLabel != null) {
                    section = pLabel.getText();
                }
                String prevSectionName = null;
                Component[] components = this.midPanel.getComponents();
                for (int i = 0; i < this.midPanel.getComponentCount(); ++i) {
                    String cName = components[i].getClass().getName();
                    if (cName.equals(PaletteItemUI.class.getName())) continue;
                    JLabel cLabel = (JLabel)components[i];
                    String cSection = cLabel.getText();
                    if (cSection.equals(section)) break;
                    prevSectionName = cSection;
                }
                section = prevSectionName;
            } else if (name.startsWith(PaletteGroupUI.class.getName())) {
                String lastSectionName = null;
                Component[] components = this.midPanel.getComponents();
                for (int i = 0; i < this.midPanel.getComponentCount(); ++i) {
                    String cName = components[i].getClass().getName();
                    if (cName.equals(PaletteItemUI.class.getName())) continue;
                    JLabel cLabel = (JLabel)components[i];
                    lastSectionName = cLabel.getText();
                }
                section = lastSectionName;
            }
        }
        return new String[]{section, item};
    }

    private String[] getAugmentedText(PaletteItem item) {
        String pageName = "";
        String groupName = "";
        Component[] components = this.midPanel.getComponents();
        for (int i = 0; i < this.midPanel.getComponentCount(); ++i) {
            PaletteItemUI itemUI;
            PaletteItem pItem;
            String cName = components[i].getClass().getName();
            if (!cName.equals(PaletteItemUI.class.getName()) || !(pItem = (itemUI = (PaletteItemUI)this.midPanel.getComponent(i)).getPaletteItem()).getItemId().equals(item.getItemId())) continue;
            pageName = itemUI.getPageName();
            groupName = itemUI.getGroupName();
            break;
        }
        return new String[]{pageName, groupName};
    }

    private class msgDisplayText
    extends JTextArea {
        public msgDisplayText(String displayText) {
            this.setText(displayText);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
            this.setEnabled(false);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(16, 24, 16, 24));
        }
    }
}

