/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.palette2.AllPagesGroupUI;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockable;
import oracle.ideimpl.palette2.PaletteGroupUI;

public class GroupDockable
extends DockableWindow
implements PaletteDockable {
    private String _viewName;
    private PaletteGroup paletteGroup;
    private String _cachedName;
    private String _cachedViewState;
    private PaletteGroupUI groupWindow;

    public GroupDockable(String viewName) {
        super("PALETTEFACTORY." + viewName);
        this._viewName = viewName;
    }

    public int getDefaultVisibility(Layout layout) {
        return 32;
    }

    public Controller getController() {
        return PaletteControllerUI.getInstance();
    }

    public String getTabName() {
        return this._cachedName;
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public void saveLayout(PropertyAccess p) {
        p.setProperty("NAME", this._cachedName);
        p.setProperty("VIEWSTATE", this.getViewState());
    }

    public void loadLayout(PropertyAccess p) {
        this._cachedName = p.getProperty("NAME", "");
        this.setViewState(p.getProperty("VIEWSTATE", "list"));
    }

    public Component getGUI() {
        if (this.groupWindow == null) {
            this.groupWindow = this._viewName.startsWith(PaletteArb.getString(57)) ? new AllPagesGroupUI(this.getViewState()) : new PaletteGroupUI(this.getViewState());
            if (this.paletteGroup != null) {
                this.groupWindow.setData(this.paletteGroup);
            }
        }
        this.groupWindow.requestFocus();
        return this.groupWindow;
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
        this.paletteGroup = paletteGroup;
        this._cachedName = paletteGroup.getName();
        if (this._cachedName == null || this._cachedName.length() == 0) {
            this._cachedName = this._viewName != null && this._viewName.length() > 0 ? this._viewName : PaletteArb.getString(3);
        }
        if (this.groupWindow != null) {
            this.groupWindow.setData(paletteGroup);
        }
    }

    @Override
    public String getViewState() {
        if (this._cachedViewState == null) {
            this._cachedViewState = "list";
        }
        return this._cachedViewState;
    }

    protected void setViewState(String vwState) {
        this._cachedViewState = vwState == null || vwState.length() == 0 ? "list" : vwState;
    }

    @Override
    public void toggleViewState() {
        if (this.groupWindow != null) {
            if (this.getViewState().equals("list")) {
                this.setViewState("icon");
            } else {
                this.setViewState("list");
            }
            this.groupWindow.toggleView(this.getViewState());
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }

    public ContextMenu getContextMenu() {
        return PaletteControllerUI.getInstance().getContextMenu();
    }
}

