/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;

public class DefaultPalettePage
extends PalettePage {
    public static final String DEFAULT_ICON = "/oracle/ideimpl/icons/images/palette/missingdefault.png";
    public static final String PAGE_PAGEID = "pageId";
    public static final String PAGE_PAGEEDITOR = "pageEditor";
    public static final String PAGE_PROJECTCONFIGURATION = "projectConfiguration";
    public static final String PAGE_SHOWFORTYPES = "showForTypes";
    public static final String PAGE_TECHNOLOGYSCOPES = "technologyScopes";
    public static final String PAGE_TYPE = "type";
    public static final String PAGE_PAGECONTEXT = "pageContext";
    private HashMap pageData = new HashMap();
    private List<PaletteGroup> paletteGroups = new ArrayList<PaletteGroup>();
    private String name;
    private String description;
    private Icon icon;
    private String iconURL;

    public DefaultPalettePage() {
    }

    public DefaultPalettePage(String name, String description, String icon, String pageId, String pageEditor, String projectConfiguration, List<String> showForTypes, List<String> technologyScopes, String type, String pageContext) {
        this(new PageRecord(name, description, icon, pageId, pageEditor, projectConfiguration, DefaultPalettePage.convertToShowForTypeRecords(showForTypes), technologyScopes, type, pageContext));
    }

    public DefaultPalettePage(String name, String description, String icon, String pageId) {
        this(name, description, icon, pageId, null, null, null, null, null, null);
    }

    public DefaultPalettePage(PageRecord record) {
        this.setName(record.name);
        this.setDescription(record.description);
        this.setIcon(record.icon);
        if (record.pageId != null) {
            this.setData(PAGE_PAGEID, record.pageId);
        }
        if (record.pageEditor != null) {
            this.setData(PAGE_PAGEEDITOR, record.pageEditor);
        }
        if (record.projectConfiguration != null) {
            this.setData(PAGE_PROJECTCONFIGURATION, record.projectConfiguration);
        }
        if (record.showForTypes != null) {
            this.setData(PAGE_SHOWFORTYPES, record.showForTypes);
        }
        if (record.technologyScopes != null) {
            this.setData(PAGE_TECHNOLOGYSCOPES, record.technologyScopes);
        }
        if (record.type != null) {
            this.setData(PAGE_TYPE, record.type);
        }
        if (record.pageContext != null) {
            this.setData(PAGE_PAGECONTEXT, record.pageContext);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.setIcon(this.getIconImage(DEFAULT_ICON));
        }
        return this.icon;
    }

    protected void setIcon(String iconParm) {
        this.iconURL = iconParm;
        if (this.iconURL != null) {
            this.setIcon(this.getIconImage(this.iconURL));
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Object getData(Object key) {
        Object data = this.pageData.get(key);
        return data;
    }

    protected void setData(Object key, Object data) {
        this.pageData.put(key, data);
    }

    public PaletteItem getItem(String itemId) {
        PaletteGroup iterGroup;
        DefaultPaletteGroup defGroup;
        PaletteItem paletteItem = null;
        Iterator<PaletteGroup> i$ = this.paletteGroups.iterator();
        while (i$.hasNext() && (paletteItem = (defGroup = (DefaultPaletteGroup)(iterGroup = i$.next())).getItem(itemId)) == null) {
        }
        return paletteItem;
    }

    public void addGroup(PaletteGroup group) {
        for (PaletteGroup iterGroup : this.paletteGroups) {
            if (!iterGroup.equals(group)) continue;
            return;
        }
        this.paletteGroups.add(group);
    }

    protected void removeGroup(DefaultPaletteGroup group) {
        if (group == null || !(group instanceof DefaultPaletteGroup)) {
            return;
        }
        for (PaletteGroup iterGroup : this.paletteGroups) {
            if (!iterGroup.equals(group)) continue;
            this.paletteGroups.remove(iterGroup);
            break;
        }
    }

    @Override
    public Collection<PaletteGroup> getGroups() {
        return Collections.unmodifiableList(this.paletteGroups);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DefaultPalettePage) {
            return this.equalsImpl((DefaultPalettePage)obj);
        }
        return false;
    }

    private boolean equalsImpl(DefaultPalettePage page) {
        String thisPageId = (String)this.getData(PAGE_PAGEID);
        String pagePageId = (String)page.getData(PAGE_PAGEID);
        return this.name.equals(page.getName()) && thisPageId.equals(pagePageId);
    }

    private static List<ShowForTypeRecord> convertToShowForTypeRecords(List<String> showForTypes) {
        ArrayList<ShowForTypeRecord> records = new ArrayList<ShowForTypeRecord>();
        if (showForTypes != null) {
            for (String item : showForTypes) {
                records.add(new ShowForTypeRecord(item));
            }
        }
        return records;
    }

    public String toString() {
        String temp = String.format("DefaultPage[ name=%s, description=%s, pageId=%s, ShowForTypes=%s, TechnologyScope=%s, Type=%s, PageContext=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getDescription()), String.valueOf(this.getData(PAGE_PAGEID)), String.valueOf(this.getData(PAGE_SHOWFORTYPES)), String.valueOf(this.getData(PAGE_TECHNOLOGYSCOPES)), String.valueOf(this.getData(PAGE_TYPE)), String.valueOf(this.getData(PAGE_PAGECONTEXT)));
        Collection<PaletteGroup> groups = this.getGroups();
        for (PaletteGroup x : groups) {
            DefaultPaletteGroup y = (DefaultPaletteGroup)x;
            temp = temp + y.toString();
        }
        return temp;
    }

    private Icon getIconImage(String iconParm) {
        ImageIcon icon = null;
        if (iconParm == null) {
            return null;
        }
        try {
            Toolkit toolkit;
            Image image;
            File file;
            URL url = null;
            int index = iconParm.indexOf("!");
            url = index != -1 ? ((iconParm = iconParm.replace('\\', '/')).indexOf("file:") == -1 ? new URL("jar:file:/" + iconParm) : new URL("jar:" + iconParm)) : this.getClass().getResource(iconParm);
            if (url == null && (file = new File(iconParm)).exists()) {
                url = file.toURL();
            }
            if (url != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(url)) != null) {
                icon = new ImageIcon(image);
            }
        }
        catch (Exception ex) {
            icon = null;
        }
        return icon;
    }

    public static final class PageRecord {
        public final String name;
        public final String description;
        public final String icon;
        public final String pageId;
        public final String pageEditor;
        public final String projectConfiguration;
        public final String type;
        public final String pageContext;
        public final List<ShowForTypeRecord> showForTypes;
        public final List<String> technologyScopes;

        public PageRecord(String name, String description, String icon, String pageId, String pageEditor, String projectConfiguration, List<ShowForTypeRecord> showForTypes, List<String> technologyScopes, String type, String pageContext) {
            this.name = name;
            this.description = description;
            this.icon = icon;
            this.pageId = pageId;
            this.pageEditor = pageEditor;
            this.projectConfiguration = projectConfiguration;
            this.type = type;
            this.pageContext = pageContext;
            this.showForTypes = showForTypes;
            this.technologyScopes = technologyScopes;
        }
    }

    public static final class ShowForTypeRecord {
        public final String docType;
        public final boolean asPreferredPage;

        public ShowForTypeRecord(String type, boolean asPreferredPage) {
            this.docType = type;
            this.asPreferredPage = asPreferredPage;
        }

        public ShowForTypeRecord(String type) {
            this(type, false);
        }

        public String toString() {
            return this.docType;
        }
    }
}

