/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.palette2.PaletteItem;

public class DefaultPaletteItem
extends PaletteItem {
    public static final String ITEM_EDITOR = "editor";
    public static final String ITEM_INFO = "info";
    public static final String ITEM_CLASSPATH = "classPath";
    public static final String ITEM_CLASSNAME = "className";
    public static final String ITEM_LIBRARY = "library";
    public static final String ITEM_TECHNOLOGYSCOPES = "technologyScopes";
    public static final String ITEM_TYPE = "type";
    public static final String ITEM_WEIGHT = "weight";
    public static final String ITEM_CODESNIPPET = "codeSnippet";
    private HashMap itemData = new HashMap();
    private String name;
    private String description;
    private Icon icon;
    private String iconURL;
    private String itemId;
    private String providerId;
    private String searchTextContext;
    private String helpable;

    public DefaultPaletteItem() {
    }

    public DefaultPaletteItem(String name, String description, String icon, String itemId, String providerId, String pageEditor, List<String> technologyScopes, String type, String info, String classPath, String className, String library, String weight, String helpable, String searchTextContext) {
        this.initFields(name, description, itemId, providerId, pageEditor, technologyScopes, type, info, classPath, className, library, weight, helpable, searchTextContext);
        this.setIcon(icon);
    }

    public DefaultPaletteItem(String name, String description, Icon icon, String itemId, String providerId, String pageEditor, List<String> technologyScopes, String type, String info, String classPath, String className, String library, String weight, String helpable, String searchTextContext) {
        this.initFields(name, description, itemId, providerId, pageEditor, technologyScopes, type, info, classPath, className, library, weight, helpable, searchTextContext);
        this.setIcon(icon);
    }

    private void initFields(String name, String description, String itemId, String providerId, String pageEditor, List<String> technologyScopes, String type, String info, String classPath, String className, String library, String weight, String helpable, String searchTextContext) {
        this.setName(name);
        this.setDescription(description);
        this.setItemId(itemId);
        this.setProviderId(providerId);
        if (pageEditor != null) {
            this.setData(ITEM_EDITOR, pageEditor);
        }
        if (technologyScopes != null) {
            this.setData(ITEM_TECHNOLOGYSCOPES, technologyScopes);
        }
        if (type != null) {
            this.setData(ITEM_TYPE, type);
        }
        if (info != null) {
            this.setData(ITEM_INFO, info);
        }
        if (classPath != null) {
            this.setData(ITEM_CLASSPATH, classPath);
        }
        if (className != null) {
            this.setData(ITEM_CLASSNAME, className);
        }
        if (library != null) {
            this.setData(ITEM_LIBRARY, library);
        }
        if (weight != null) {
            this.setData(ITEM_WEIGHT, weight);
        }
        this.setHelpable(helpable);
        this.setSearchTextContext(searchTextContext);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.setIcon(this.getIconImage("/oracle/ideimpl/icons/images/palette/missingdefault.png"));
        }
        return this.icon;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    protected void setIcon(String iconParm) {
        this.iconURL = iconParm;
        if (this.iconURL != null) {
            this.setIcon(this.getIconImage(this.iconURL));
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getItemId() {
        return this.itemId;
    }

    protected void setItemId(String itemId) {
        this.itemId = itemId;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    protected void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @Override
    public String getSearchTextContext() {
        return this.searchTextContext;
    }

    protected void setSearchTextContext(String searchTextContext) {
        this.searchTextContext = searchTextContext;
    }

    @Override
    public String getHelpable() {
        return this.helpable;
    }

    protected void setHelpable(String helpable) {
        this.helpable = helpable;
    }

    @Override
    public Object getData(Object key) {
        Object data = this.itemData.get(key);
        return data;
    }

    public void setData(Object key, Object data) {
        this.itemData.put(key, data);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DefaultPaletteItem) {
            return this.equalsImpl((DefaultPaletteItem)obj);
        }
        return false;
    }

    private boolean equalsImpl(DefaultPaletteItem item) {
        return this.providerId.equals(item.getProviderId()) && this.itemId.equals(item.getItemId());
    }

    public String toString() {
        String temp = String.format("DefaultItem[ name=%s, description=%s, itemId=%s, info=%s, TechnologyScope=%s, Type=%s, Library=%s, ClassPath=%s, ClassName=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getDescription()), String.valueOf(this.getItemId()), String.valueOf(this.getData(ITEM_INFO)), String.valueOf(this.getData(ITEM_TECHNOLOGYSCOPES)), String.valueOf(this.getData(ITEM_TYPE)), String.valueOf(this.getData(ITEM_LIBRARY)), String.valueOf(this.getData(ITEM_CLASSPATH)), String.valueOf(this.getData(ITEM_CLASSNAME)));
        return temp;
    }

    private Icon getIconImage(String iconParm) {
        ImageIcon icon = null;
        if (iconParm == null) {
            return null;
        }
        try {
            Toolkit toolkit;
            Image image;
            File file;
            URL url = null;
            int index = iconParm.indexOf(":");
            url = index != -1 ? new URL(iconParm) : this.getClass().getResource(iconParm);
            if (url == null && (file = new File(iconParm)).exists()) {
                url = file.toURL();
            }
            if (url != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(url)) != null) {
                icon = new ImageIcon(image);
            }
        }
        catch (Exception ex) {
            icon = null;
        }
        return icon;
    }
}

