/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public class DefaultPaletteGroup
extends PaletteGroup {
    public static final String GROUP_GROUPID = "groupId";
    public static final String GROUP_GROUPEDITOR = "groupEditor";
    public static final String GROUP_PROJECTCONFIGURATION = "projectConfiguration";
    public static final String GROUP_SHOWFORTYPES = "showForTypes";
    public static final String GROUP_TECHNOLOGYSCOPES = "technologyScopes";
    public static final String GROUP_TYPE = "type";
    private HashMap groupData = new HashMap();
    private List<PaletteSection> paletteSections = new ArrayList<PaletteSection>();
    private String name;
    private String description;
    private Icon icon;
    private String iconURL;

    public DefaultPaletteGroup() {
    }

    public DefaultPaletteGroup(String name, String description, String groupId, String type) {
        this(name, description, null, groupId, null, null, null, null, type);
    }

    public DefaultPaletteGroup(String name, String description, String icon, String groupId, String groupEditor, String projectConfiguration, List<String> showForTypes, List<String> technologyScopes, String type) {
        this.setName(name);
        this.setDescription(description);
        this.setIcon(icon);
        if (groupId != null) {
            this.setData(GROUP_GROUPID, groupId);
        }
        if (groupEditor != null) {
            this.setData(GROUP_GROUPEDITOR, groupEditor);
        }
        if (projectConfiguration != null) {
            this.setData(GROUP_PROJECTCONFIGURATION, projectConfiguration);
        }
        if (showForTypes != null) {
            this.setData(GROUP_SHOWFORTYPES, showForTypes);
        }
        if (technologyScopes != null) {
            this.setData(GROUP_TECHNOLOGYSCOPES, technologyScopes);
        }
        if (type != null) {
            this.setData(GROUP_TYPE, type);
        }
    }

    @Override
    public Object getData(Object key) {
        return this.groupData.get(key);
    }

    protected void setData(Object key, Object data) {
        this.groupData.put(key, data);
    }

    public PaletteItem getItem(String itemId) {
        PaletteSection iterSection;
        PaletteItem paletteItem = null;
        Iterator<PaletteSection> i$ = this.paletteSections.iterator();
        while (i$.hasNext() && (paletteItem = ((DefaultPaletteSection)(iterSection = i$.next())).getItem(itemId)) == null) {
        }
        return paletteItem;
    }

    public void addSection(PaletteSection section) {
        for (PaletteSection iterSection : this.paletteSections) {
            if (!iterSection.equals(section)) continue;
            return;
        }
        this.paletteSections.add(section);
    }

    protected void removeSection(PaletteSection section) {
        if (section == null || !(section instanceof PaletteSection)) {
            return;
        }
        for (PaletteSection iterSection : this.paletteSections) {
            if (!iterSection.equals(section)) continue;
            this.paletteSections.remove(iterSection);
            break;
        }
    }

    protected void removeAllSections() {
        this.paletteSections.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.setIcon(this.getIconImage("/oracle/ideimpl/icons/images/palette/missingdefault.png"));
        }
        return this.icon;
    }

    protected void setIcon(String iconParm) {
        this.iconURL = iconParm;
        if (this.iconURL != null) {
            this.setIcon(this.getIconImage(this.iconURL));
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Collection<PaletteSection> getSections() {
        return Collections.unmodifiableList(this.paletteSections);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DefaultPaletteGroup) {
            return this.equalsImpl((DefaultPaletteGroup)obj);
        }
        return false;
    }

    private boolean equalsImpl(DefaultPaletteGroup group) {
        String thisGroupId = (String)this.getData(GROUP_GROUPID);
        String pageGroupId = (String)group.getData(GROUP_GROUPID);
        return this.name.equals(group.getName()) && thisGroupId.equals(pageGroupId);
    }

    public String toString() {
        String temp = String.format("DefaultGroup[ name=%s, description=%s, groupId=%s, ShowForTypes=%s, TechnologyScope=%s, Type=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getDescription()), String.valueOf(this.getData(GROUP_GROUPID)), String.valueOf(this.getData(GROUP_SHOWFORTYPES)), String.valueOf(this.getData(GROUP_TECHNOLOGYSCOPES)), String.valueOf(this.getData(GROUP_TYPE)));
        Collection<PaletteSection> sections = this.getSections();
        for (PaletteSection x : sections) {
            DefaultPaletteSection y = (DefaultPaletteSection)x;
            temp = temp + y.toString();
        }
        return temp;
    }

    private Icon getIconImage(String iconParm) {
        ImageIcon icon = null;
        if (iconParm == null) {
            return null;
        }
        try {
            Toolkit toolkit;
            Image image;
            File file;
            URL url = null;
            int index = iconParm.indexOf("!");
            url = index != -1 ? ((iconParm = iconParm.replace('\\', '/')).indexOf("file:") == -1 ? new URL("jar:file:/" + iconParm) : new URL("jar:" + iconParm)) : this.getClass().getResource(iconParm);
            if (url == null && (file = new File(iconParm)).exists()) {
                url = file.toURL();
            }
            if (url != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(url)) != null) {
                icon = new ImageIcon(image);
            }
        }
        catch (Exception ex) {
            icon = null;
        }
        return icon;
    }

    @Override
    public boolean isVisible(Context context) {
        return true;
    }
}

