/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.runner;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.ide.extension.Extension;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.xml.xquery.runner.XQueryRunner;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;

public class XQueryStarter
extends JStarter {
    private static final String XML_PARSER_JAR = "xmlparserv2.jar";
    private static final String XQUERY_JAR = "xquery.jar";
    private static final String ORA_COLLATION_JAR = "orai18n-collation.jar";
    private static final String EXTENSION_ID = "oracle.jdeveloper.runner";
    private static final String JDEVRUNNER_JAR_PATH = "jdev/extensions/oracle.jdeveloper.runner.jar";
    private Node target;
    private Thread xqueryThread;
    private LogPage logPage;
    private static final boolean PREVIEW_MODE = Boolean.getBoolean("xquery.preview.mode");

    public XQueryStarter(JRunProcess runProcess, Node target) {
        super(runProcess, new String[]{XQueryRunner.class.getName(), URLFileSystem.getPlatformPathName((URL)target.getURL())});
        this.target = target;
    }

    public boolean start() {
        if (PREVIEW_MODE) {
            this.logPage = this.runProcess.getLogPage();
            this.xqueryThread = new Thread("XQuery"){

                @Override
                public void run() {
                    XQueryStarter.this.runXQuery();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            XQueryStarter.this.runProcess.finished();
                            XQueryStarter.this.finished();
                        }
                    });
                }
            };
            this.xqueryThread.start();
            return true;
        }
        return super.start();
    }

    public int waitForProcess() {
        if (PREVIEW_MODE) {
            try {
                this.xqueryThread.join();
            }
            catch (InterruptedException ie) {
                this.terminate();
            }
            Integer exitCode = this.getExitCode();
            return exitCode != null ? exitCode : -1;
        }
        return super.waitForProcess();
    }

    public File getStartDirectory() {
        URL targetDir;
        File startDir = super.getStartDirectory();
        if (startDir == null && (targetDir = URLFileSystem.getParent((URL)this.target.getURL())) != null) {
            startDir = new File(targetDir.getPath());
        }
        return startDir;
    }

    @Override
    protected String getClassPath() {
        StringBuffer buffer = new StringBuffer();
        Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(EXTENSION_ID);
        if (ext != null) {
            Iterator urls = ext.getClassPath().iterator();
            String xQueryJarPath = "";
            String xmlParserJarPath = "";
            String orai18JarPath = "";
            while (urls.hasNext()) {
                String jarPath = ((URI)urls.next()).getPath();
                if (jarPath != null) {
                    if (jarPath.contains(XML_PARSER_JAR)) {
                        xmlParserJarPath = jarPath;
                    } else if (jarPath.contains(XQUERY_JAR)) {
                        xQueryJarPath = jarPath;
                    } else if (jarPath.contains(ORA_COLLATION_JAR)) {
                        orai18JarPath = jarPath;
                    }
                }
                if (xQueryJarPath.isEmpty() || xmlParserJarPath.isEmpty() || orai18JarPath.isEmpty()) continue;
                break;
            }
            if (!xQueryJarPath.isEmpty()) {
                File xqueryJar = new File(xQueryJarPath);
                buffer.append(xqueryJar);
                buffer.append(File.pathSeparator);
            }
            if (!xmlParserJarPath.isEmpty()) {
                File xmlParserJar = new File(xmlParserJarPath);
                buffer.append(xmlParserJar);
                buffer.append(File.pathSeparator);
            }
            if (!orai18JarPath.isEmpty()) {
                File orai18nJar = new File(orai18JarPath);
                buffer.append(orai18nJar);
                buffer.append(File.pathSeparator);
            }
        }
        File jdevJar = new File(Ide.getLibDirectory(), "jdev.jar");
        buffer.append(jdevJar);
        buffer.append(File.pathSeparator);
        File extJar = new File(Ide.getOracleHomeDirectory(), JDEVRUNNER_JAR_PATH);
        buffer.append(extJar);
        return buffer.toString();
    }

    @Override
    protected void addJavaOptions(List list) {
        super.addJavaOptions(list);
        list.add("-Xverify:none");
    }

    private void runXQuery() {
        try {
            Reader reader = this.getReader();
            XQueryContext context = new XQueryContext();
            Configuration config = new Configuration();
            config.setBaseURI(URLFileSystem.getParent((URL)this.target.getURL()).toString());
            PreparedXQuery query = context.prepareXQuery(reader, config);
            XMLSequence result = query.executeQuery();
            while (result.next()) {
                String output = XQueryRunner.getOutputString(result.getCurrentItem());
                if (output == null) continue;
                StyledMessage message = new StyledMessage((AttributeSet)RunProcess.getSystemOutAttributeSet(), output + "\n");
                this.logPage.log((Object)message);
            }
        }
        catch (XQException xqe) {
            StyledMessage message = new StyledMessage((AttributeSet)RunProcess.getSystemErrAttributeSet(), xqe.getLocalizedMessage() + "\n");
            this.logPage.log((Object)message);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getReader() throws FileNotFoundException {
        InputStreamReader reader = null;
        if (this.target instanceof TextNode) {
            TextNode textNode = (TextNode)this.target;
            TextBuffer buffer = textNode.acquireTextBuffer();
            try {
                InputStream in = TextBufferStreamFactory.getInputStream((TextBuffer)buffer);
                reader = new InputStreamReader(in);
            }
            finally {
                textNode.releaseTextBuffer();
            }
        }
        if (reader == null) {
            URL url = this.target.getURL();
            String path = URLFileSystem.getPlatformPathName((URL)url);
            reader = new FileReader(path);
        }
        return reader;
    }
}

