/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.xslt;

import java.net.URL;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;

public final class XSLTConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = XSLTConfiguration.class.getName();
    protected static final String INPUT_FILE_URL = "inputFileURL";
    protected static final String SHOW_INPUT_FILE = "showInputFile";
    protected static final String OUTPUT_FILE_URL = "outputFileURL";
    protected static final String SHOW_OUTPUT_FILE = "showOutputFile";
    protected static final String SOURCE_PATH = "sourcePath";
    protected static final String XSLT_OPTIONS = "xsltOptions";

    private XSLTConfiguration(HashStructure hash) {
        super(hash);
    }

    public static XSLTConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof RunConfiguration) {
            return new XSLTConfiguration(XSLTConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }
        RunConfiguration runConfiguration = RunConfiguration.getInstance(propertyStorage);
        return XSLTConfiguration.getInstance(runConfiguration);
    }

    public URL getInputFileURL() {
        return this._hash.getURL(INPUT_FILE_URL, null);
    }

    public void setInputFileURL(URL inputFileURL) {
        this._hash.putURL(INPUT_FILE_URL, inputFileURL);
    }

    public boolean isShowInputFile() {
        return this._hash.getBoolean(SHOW_INPUT_FILE, true);
    }

    public void setShowInputFile(boolean showInputFile) {
        this._hash.putBoolean(SHOW_INPUT_FILE, showInputFile);
    }

    public URL getOutputFileURL() {
        return this._hash.getURL(OUTPUT_FILE_URL, null);
    }

    public void setOutputFileURL(URL outputFileURL) {
        this._hash.putURL(OUTPUT_FILE_URL, outputFileURL);
    }

    public boolean isShowOutputFile() {
        return this._hash.getBoolean(SHOW_OUTPUT_FILE, true);
    }

    public void setShowOutputFile(boolean showOutputFile) {
        this._hash.putBoolean(SHOW_OUTPUT_FILE, showOutputFile);
    }

    public URLPath getSourcePath() {
        return URLPath.getURLPath((HashStructure)this._hash, (String)SOURCE_PATH);
    }

    public void setSourcePath(URLPath sourcePath) {
        URLPath.setURLPath((HashStructure)this._hash, (String)SOURCE_PATH, (URLPath)sourcePath);
    }

    public String getXSLTOptions() {
        return this._hash.getString(XSLT_OPTIONS, "");
    }

    public void setXSLTOptions(String XSLTOptions) {
        if (XSLTOptions == null) {
            XSLTOptions = "";
        }
        this._hash.putString(XSLT_OPTIONS, XSLTOptions);
    }
}

