/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.Pair;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.ListenerMessage;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqRemoveListener;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ListenersOutput
implements DebuggerProcessListener,
ReplyListener,
TreeSelectionListener,
MouseListener,
ActionListener {
    private static final String MENU_CLEAR = UIDebugArb.getString(29);
    private static final String MENU_REMOVE = UIDebugArb.getString(28);
    private final DebuggerProcess _process;
    private JComponent _UI;
    private JTree _tree;
    private final DefaultMutableTreeNode _root;
    private DefaultListSelectionModel _selModel;
    private final boolean _rootExpanded = false;

    public ListenersOutput(DebuggerProcess process) {
        this._process = process;
        this._root = new DefaultMutableTreeNode();
        this._process.getReceiveQueue().addReplyListener(this);
        this._process.addDebuggerProcessListener(this);
    }

    public JComponent getGUI() {
        if (this._UI == null) {
            this._tree = new JTree(this._root);
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._selModel = new DefaultListSelectionModel();
            this._selModel.setSelectionMode(0);
            this._tree.addTreeSelectionListener(this);
            this._tree.addMouseListener(this);
            this._UI = new JScrollPane(this._tree);
            this._UI.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._UI;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        XComponent xComponent;
        ListenerMessage selectedMessage = this.getSelectedMessage();
        if (selectedMessage != null && (xComponent = selectedMessage.getXComponent()) != null) {
            this._process.setSelection(xComponent);
        }
    }

    private ListenerMessage getSelectedMessage() {
        ListenerMessage message = null;
        TreePath selectionPath = this._tree.getSelectionPath();
        if (selectionPath != null) {
            int n = selectionPath.getPathCount();
            for (int i = n - 1; i > 0; --i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getPathComponent(i);
                if (!(node.getUserObject() instanceof ListenerMessage)) continue;
                message = (ListenerMessage)node.getUserObject();
            }
        }
        return message;
    }

    @Override
    public void replyReceived(ReplyEvent event) {
        Reply reply = event.getReply();
        switch (reply.getRequestType()) {
            case 100: {
                this.whenNewEvent((ListenerMessage)reply);
            }
        }
    }

    private void whenNewEvent(ListenerMessage reply) {
        DefaultMutableTreeNode replyNode = new DefaultMutableTreeNode(reply);
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        Pair[] properties = reply.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Pair property = properties[i];
            String propertyLabel = property.first + " = " + property.second;
            replyNode.add(new DefaultMutableTreeNode(propertyLabel));
        }
        model.insertNodeInto(replyNode, this._root, this._root.getChildCount());
        this._tree.expandPath(new TreePath(this._root));
        int lastRow = this._tree.getRowCount() - 1;
        Rectangle lastItemBounds = this._tree.getRowBounds(lastRow);
        this._tree.scrollRectToVisible(lastItemBounds);
    }

    private void showContextMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemClear = new JMenuItem(MENU_CLEAR);
        itemClear.addActionListener(this);
        JMenuItem itemRemoveListener = new JMenuItem(MENU_REMOVE);
        itemRemoveListener.addActionListener(this);
        popup.add(itemClear);
        popup.add(itemRemoveListener);
        Point showPoint = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (MouseEvent)e);
        Component component = e.getComponent();
        popup.show(component, showPoint.x, showPoint.y);
    }

    private void whenMouseButton(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e);
        }
    }

    private void whenClear() {
        this._root.removeAllChildren();
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.reload();
    }

    private void whenRemove() {
        ListenerMessage listenerMessage = this.getSelectedMessage();
        if (listenerMessage != null) {
            int listenerID = listenerMessage.getListenerRefID();
            ReqRemoveListener reqRemoveListener = new ReqRemoveListener(listenerID);
            DebuggerProcess activeDebuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
            int rootID = listenerMessage.getRootID();
            XComponent xComponent = activeDebuggerProcess.searchReference(rootID);
            xComponent.getListeners().removeListener(listenerID);
            activeDebuggerProcess.pushRequest(reqRemoveListener);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.whenMouseButton(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.whenMouseButton(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.whenMouseButton(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sCommand = e.getActionCommand();
        if (MENU_CLEAR.equals(sCommand)) {
            this.whenClear();
        } else if (MENU_REMOVE.equals(sCommand)) {
            this.whenRemove();
        }
    }

    @Override
    public void rootChanging(DebuggerProcessEvent event) {
    }

    @Override
    public void stateChanged(DebuggerProcessEvent event) {
    }

    @Override
    public void rootChanged(DebuggerProcessEvent event) {
        if (this._UI != null) {
            DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
            model.nodeStructureChanged(this._root);
        }
    }
}

