/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.reply;

import java.io.IOException;
import java.util.Arrays;
import oracle.ide.util.Pair;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.DefaultReply;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ListenerMessage
extends DefaultReply {
    public static final int REQUEST_TYPE = 100;
    private int _rootID;
    private int _listenerRefID;
    private XComponent _xComponent;
    private Pair[] _properties;
    private String _methodName;
    private DebuggerProcess _debuggerProcess;
    private int _componentID;

    public ListenerMessage(int nRequestID) {
        super(nRequestID, 100);
    }

    @Override
    public void readReply(DebugStream stream) throws IOException {
        this._rootID = stream.readInt();
        this._listenerRefID = stream.readInt();
        this._componentID = stream.readInt();
        Debugger debugger = Debugger.getInstance();
        this._debuggerProcess = debugger.getActiveDebuggerProcess();
        this._methodName = stream.readUTF();
        int n = stream.readInt();
        this._properties = new Pair[n];
        for (int i = 0; i < n; ++i) {
            String propertyName = stream.readUTF();
            String propertyValue = stream.readUTF();
            this._properties[i] = new Pair((Object)propertyName, (Object)propertyValue);
        }
        Arrays.sort(this._properties);
    }

    public int getRootID() {
        return this._rootID;
    }

    public int getListenerRefID() {
        return this._listenerRefID;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Pair[] getProperties() {
        return this._properties;
    }

    public XComponent getXComponent() {
        if (this._xComponent == null) {
            this._xComponent = this._debuggerProcess.searchReference(this._componentID);
        }
        return this._xComponent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        XComponent xComponent = this.getXComponent();
        if (xComponent != null) {
            sb.append(xComponent.toString());
        } else {
            sb.append(UIDebugArb.getString(12));
        }
        sb.append(".");
        sb.append(this._methodName);
        sb.append("()");
        return sb.toString();
    }
}

