/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WindowProviderCallback;

class WindowManager {
    private Map<String, WindowProviderCallback> debuggerWindowProviders = new HashMap<String, WindowProviderCallback>();

    WindowManager() {
    }

    DebuggerWindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider, boolean customWindow) {
        WindowProviderCallback callback = new WindowProviderCallback(this, provider, customWindow);
        String ID = provider.getWindow().getId();
        this.debuggerWindowProviders.put(ID, callback);
        return callback;
    }

    void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
        String ID = provider.getWindow().getId();
        this.debuggerWindowProviders.remove(ID);
    }

    DockableWindow getDebuggerWindow(String windowID) {
        WindowProviderCallback callback = this.debuggerWindowProviders.get(windowID);
        if (callback != null) {
            return callback.getProvider().getWindow();
        }
        return null;
    }

    DebuggerWindowProvider getDebuggerWindowProvider(String windowID) {
        WindowProviderCallback callback = this.debuggerWindowProviders.get(windowID);
        if (callback != null) {
            return callback.getProvider();
        }
        return null;
    }

    void installWindow(String windowID) {
        ViewId viewId;
        DockStation ds = DockStation.getDockStation();
        if (ds.getDockable(viewId = new ViewId(windowID)) != null) {
            return;
        }
        JDebugger.getInstance().getOrCreateDebuggerWindow(windowID);
        DebugDockableFactory factory = JDebugger.getInstance().getDebugDockableFactory();
        DebuggerWindowProvider provider = this.getDebuggerWindowProvider(windowID);
        if (provider != null) {
            LogWindow tabbedWith = null;
            Object reference = null;
            int position = 0;
            switch (provider.getPosition()) {
                case SOUTH: {
                    tabbedWith = LogManager.getIdeLogWindow();
                    position = 3;
                    break;
                }
                case WEST: {
                    tabbedWith = ds.findDockable(ExplorerManager.getExplorerManager().getDefaultViewId());
                    position = 0;
                    break;
                }
                case EAST: {
                    if (windowID != "Debugger.ClassesWindow") {
                        tabbedWith = ds.findDockable(new ViewId("Debugger.ClassesWindow"));
                    }
                    position = 1;
                    break;
                }
                case FLOATING: {
                    factory.floatWindow(provider.getWindow(), provider.getFloatingPosition());
                    return;
                }
            }
            factory.installWindow(provider.getWindow(), (Dockable)tabbedWith, position);
        }
    }

    void installCustomWindows() {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            if (!callback.isCustomWindow() || !callback.getProvider().installByDefault()) continue;
            this.installWindow(callback.getProvider().getWindow().getId());
        }
    }

    void setDebuggerWindowProvidersContext(Context context) {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            try {
                callback.getProvider().setContext(context);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void refreshCustomWindows(Evaluator evaluator, DebuggingProcess process) {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            if (!callback.isCustomWindow()) continue;
            try {
                long milliTime = System.currentTimeMillis();
                if (evaluator != null && process != null) {
                    EvaluatorHandle handle = new EvaluatorHandle(evaluator, process, callback.getCustomDataProvider());
                    callback.getProvider().setEvaluator((DebuggerEvaluator)handle);
                }
                callback.getProvider().refresh();
                if (!JDebugger.logger.isEnabled()) continue;
                JDebugger.logger.trace("Refresh window: " + callback.getProvider().getWindow().getId() + " in " + (System.currentTimeMillis() - milliTime) + " msecs");
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void refreshCustomWindows() {
        this.refreshCustomWindows(null, null);
    }

    void shutdownWindows() {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            try {
                callback.getProvider().shutDown();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }
}

