/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Project;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditWatchDialog;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;

final class WatchWindow
extends DataWindow {
    private WatchWindowSettings watchWindowSettings = WatchWindowSettings.getInstance();
    private static IdeAction actionAddNewWatch;
    private static IdeAction actionEditWatch;
    private static IdeAction actionRemoveWatch;
    private static IdeAction actionPin;
    private static IdeAction actionUnpin;
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionRemoveAllWatches;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewWatch;
    private static JMenuItem menuitemEditWatch;
    private static JMenuItem menuitemRemoveWatch;
    private static JMenuItem menuitemRemoveAllWatches;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_WATCH_CMD_ID;
    private static final int EDIT_WATCH_CMD_ID;
    private static final int REMOVE_WATCH_CMD_ID;
    private static final int PIN_CMD_ID;
    private static final int UNPIN_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_WATCHES_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String WATCH_WINDOW_ID = "Debugger.WatchWindow";
    private static Icon watchTabIcon;
    private static final String expHistoryName = "DebuggerWatch";
    private static final String WATCH_KEY_COUNT = "Watch.Count";
    private static final String WATCH_KEY_PREFIX = "Watch.";
    private static final String WATCH_KEY_DOT = ".";
    private static final String WATCH_KEY_SCOPE = "scope";
    private static final String WATCH_KEY_EXPRESSION = "expression";
    private static final String WATCH_KEY_NAME = "name";
    private static final String WATCH_KEY_SHOWPINNEDDISCARDED = "showPinnedDiscarded";
    private static final String GlobalWatchScope = "GlobalWatchScope";

    WatchWindow() {
        super(WATCH_WINDOW_ID, DbgArb.getString(597), "f1_deb_watchwindow_html");
        WatchWindow.makeActions();
        this.setDataPanel(new WatchPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        if (watchTabIcon == null) {
            watchTabIcon = OracleIcons.getIcon((String)"watch.png");
        }
        return watchTabIcon;
    }

    EvaluatorItem addWatch(Object expression) {
        return ((WatchPanel)this.dataPanel).addWatch(expression);
    }

    boolean removeWatch(EvaluatorItem ei) {
        return ((WatchPanel)this.dataPanel).removeWatch(ei);
    }

    boolean addWatchDialog(String expression) {
        return ((WatchPanel)this.dataPanel).addWatchDialog(expression);
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        ((WatchPanel)this.dataPanel).saveWatches((PropertyAccess)Ide.getIdeProperties());
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        WatchWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAddNewWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditWatch), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPin), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUnpin), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAllWatches), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionEditWatch == null) {
            actionEditWatch = IdeAction.get((int)EDIT_WATCH_CMD_ID, null, (String)DbgArb.getString(598), null, (Integer)DbgArb.getInteger(599), null, null, (boolean)false);
            actionEditWatch.setEnabled(false);
            actionRemoveWatch = IdeAction.get((int)REMOVE_WATCH_CMD_ID, null, (String)DbgArb.getString(600), null, (Integer)DbgArb.getInteger(601), null, null, (boolean)false);
            actionRemoveWatch.setEnabled(false);
            actionPin = IdeAction.get((int)PIN_CMD_ID, null, (String)DbgArb.getString(639), null, (Integer)DbgArb.getInteger(640), null, null, (boolean)false);
            actionPin.setEnabled(false);
            actionUnpin = IdeAction.get((int)UNPIN_CMD_ID, null, (String)DbgArb.getString(641), null, (Integer)DbgArb.getInteger(642), null, null, (boolean)false);
            actionUnpin.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(286), null, (Integer)DbgArb.getInteger(287), null, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(280), null, (Integer)DbgArb.getInteger(283), null, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(280));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(284), null, (Integer)DbgArb.getInteger(285), null, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(288), null, (Integer)DbgArb.getInteger(289), null, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(290), null, (Integer)DbgArb.getInteger(291), null, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(292), null, (Integer)DbgArb.getInteger(293), null, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(296), null, (Integer)DbgArb.getInteger(297), null, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(298), null, (Integer)DbgArb.getInteger(299), null, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(312), null, (Integer)DbgArb.getInteger(313), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(314), null, (Integer)DbgArb.getInteger(315), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(300), null, (Integer)DbgArb.getInteger(302), null, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(300));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(303), null, (Integer)DbgArb.getInteger(305), null, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(303));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(306), null, (Integer)DbgArb.getInteger(308), null, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(306));
            actionGotoField.setEnabled(false);
            actionAddNewWatch = IdeAction.get((int)ADD_NEW_WATCH_CMD_ID, null, (String)DbgArb.getString(602), null, (Integer)DbgArb.getInteger(603), null, null, (boolean)false);
            actionAddNewWatch.setEnabled(false);
            actionRemoveAllWatches = IdeAction.get((int)REMOVE_ALL_WATCHES_CMD_ID, null, (String)DbgArb.getString(604), null, (Integer)DbgArb.getInteger(605), null, null, (boolean)false);
            actionRemoveAllWatches.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(316), null, (Integer)DbgArb.getInteger(317), null, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(318, ""), null, (Integer)DbgArb.getInteger(319), null, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(102), null, (Integer)RunMgrArb.getInteger(103), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(100), null, (Integer)RunMgrArb.getInteger(101), null, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionEditWatch, actionRemoveWatch, actionPin, actionUnpin, actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewWatch, actionRemoveAllWatches, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    static {
        ADD_NEW_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchAddNewWatch");
        EDIT_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchEditWatch");
        REMOVE_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchRemoveWatch");
        PIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchPin");
        UNPIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchUnpin");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGotoField");
        REMOVE_ALL_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchRemoveAllWatches");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchSettings");
        watchTabIcon = null;
    }

    final class WatchPanel
    extends EvaluatorPanel {
        private Map allWatches;

        WatchPanel() {
            super(WatchWindow.this, WatchWindow.this.watchWindowSettings.getDataPanelSettings());
            this.loadWatches((PropertyAccess)Ide.getIdeProperties());
            this._actionPin = actionPin;
            this._actionUnpin = actionUnpin;
            this._actionViewWhole = actionViewWhole;
            this._actionViewAnnotations = actionViewAnnotations;
            this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
            this._actionAdjustRange = actionAdjustRange;
            this._actionToggleValue = actionToggleValue;
            this._actionModifyValue = actionModifyValue;
            this._actionWatch = actionWatch;
            this._actionInspect = actionInspect;
            this._actionWatchClassLoader = actionWatchClassLoader;
            this._actionInspectClassLoader = actionInspectClassLoader;
            this._actionGoto = actionGoto;
            this._actionGotoDeclared = actionGotoDeclared;
            this._actionGotoField = actionGotoField;
            this._actionUseFilters = actionUseFilters;
            this._actionObjectPreferences = actionObjectPreferences;
            this._actionCollapseAll = actionCollapseAll;
            this._actionSave = actionSave;
            this._PIN_CMD_ID = PIN_CMD_ID;
            this._UNPIN_CMD_ID = UNPIN_CMD_ID;
            this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
            this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
            this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
            this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
            this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
            this._WATCH_CMD_ID = WATCH_CMD_ID;
            this._INSPECT_CMD_ID = INSPECT_CMD_ID;
            this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
            this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
            this._GOTO_CMD_ID = GOTO_CMD_ID;
            this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
            this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
            this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
            this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
            this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
            this._SAVE_CMD_ID = SAVE_CMD_ID;
        }

        @Override
        protected void adjustGUI() {
            this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    switch (key) {
                        case 127: {
                            Context context = WatchPanel.this.getContext(e);
                            WatchPanel.this.update(actionRemoveWatch, context);
                            if (!actionRemoveWatch.isEnabled()) break;
                            WatchPanel.this.handleEvent(actionRemoveWatch, context);
                            e.consume();
                        }
                    }
                }
            });
        }

        @Override
        void processFinished(DebuggingProcess debuggingProcess) {
            List watches = this.getWatchesForProject(debuggingProcess);
            if (watches != null) {
                int size = watches.size();
                for (int i = size - 1; i >= 0; --i) {
                    EvaluatorItem ei = (EvaluatorItem)watches.get(i);
                    if (ei.isPinned(debuggingProcess)) {
                        ei.unpin(debuggingProcess);
                    }
                    if (ei.getTemporary() != debuggingProcess) continue;
                    watches.remove(i);
                }
            }
            super.processFinished(debuggingProcess);
        }

        @Override
        protected void checkDrag(DropTargetDragEvent e) {
            int action;
            if ((e.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || e.isDataFlavorSupported(ClassesWindow.getInterfaceFlavor()) || e.isDataFlavorSupported(DataItem.getExpressionFlavor()) || e.isDataFlavorSupported(DataFlavor.stringFlavor)) && ((action = e.getSourceActions()) == 1 || action == 3)) {
                e.acceptDrag(action);
                return;
            }
            super.checkDrag(e);
        }

        @Override
        protected void checkDrop(DropTargetDropEvent e) {
            if (e.isLocalTransfer()) {
                if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                        JDebugger.getInstance().addWatch(data.getName());
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(ClassesWindow.getInterfaceFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getInterfaceFlavor());
                        JDebugger.getInstance().addWatch(data.getName());
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(DataItem.getExpressionFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        Expression expression = (Expression)t.getTransferData(DataItem.getExpressionFlavor());
                        JDebugger.getInstance().addWatch(new EvaluatorItem(expression));
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        Transferable t = e.getTransferable();
                        String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                        JDebugger.getInstance().addWatch(s);
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            super.checkDrop(e);
        }

        private void loadWatches(PropertyAccess properties) {
            this.allWatches = new HashMap();
            String s = properties.getProperty(WatchWindow.WATCH_KEY_COUNT, null);
            if (s != null) {
                try {
                    int count = Integer.parseInt(s);
                    for (int i = 0; i < count; ++i) {
                        this.loadWatch(properties, i);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void loadWatch(PropertyAccess properties, int number) {
            String prefix = WatchWindow.WATCH_KEY_PREFIX + number + WatchWindow.WATCH_KEY_DOT;
            String scope = properties.getProperty(prefix + WatchWindow.WATCH_KEY_SCOPE, WatchWindow.GlobalWatchScope);
            String exp = properties.getProperty(prefix + WatchWindow.WATCH_KEY_EXPRESSION, null);
            if (exp != null && exp.length() > 0) {
                ArrayList<EvaluatorItem> list = (ArrayList<EvaluatorItem>)this.allWatches.get(scope);
                if (list == null) {
                    list = new ArrayList<EvaluatorItem>();
                    this.allWatches.put(scope, list);
                }
                EvaluatorItem ei = new EvaluatorItem(exp);
                String name = properties.getProperty(prefix + WatchWindow.WATCH_KEY_NAME, null);
                if (name != null) {
                    String s = properties.getProperty(prefix + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
                    boolean showPinnedDiscarded = Boolean.valueOf(s);
                    ei.setOptions(name, showPinnedDiscarded, null);
                }
                list.add(ei);
            }
        }

        private void saveWatches(PropertyAccess properties) {
            int previousCount = 0;
            String s = properties.getProperty(WatchWindow.WATCH_KEY_COUNT, null);
            if (s != null) {
                try {
                    previousCount = Integer.parseInt(s);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int count = 0;
            for (String scope : this.allWatches.keySet()) {
                List list = (List)this.allWatches.get(scope);
                for (EvaluatorItem ei : list) {
                    String expression = ei.getExpression();
                    if (expression == null) continue;
                    this.saveWatch(properties, count, scope, ei);
                    ++count;
                }
            }
            for (int i = count; i < previousCount; ++i) {
                this.removeSavedWatch(properties, i);
            }
            properties.setProperty(WatchWindow.WATCH_KEY_COUNT, Integer.toString(count));
        }

        private void saveWatch(PropertyAccess properties, int number, String scope, EvaluatorItem ei) {
            String prefix = WatchWindow.WATCH_KEY_PREFIX + number + WatchWindow.WATCH_KEY_DOT;
            properties.setProperty(prefix + WatchWindow.WATCH_KEY_SCOPE, scope);
            properties.setProperty(prefix + WatchWindow.WATCH_KEY_EXPRESSION, ei.getExpression());
            String name = ei.getName();
            if (name != null) {
                properties.setProperty(prefix + WatchWindow.WATCH_KEY_NAME, name);
                if (ei.isShowPinnedDiscarded()) {
                    properties.setProperty(prefix + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, Boolean.toString(true));
                } else {
                    properties.setProperty(prefix + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
                }
            } else {
                properties.setProperty(prefix + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
            }
        }

        private void removeSavedWatch(PropertyAccess properties, int number) {
            String prefix = WatchWindow.WATCH_KEY_PREFIX + number + WatchWindow.WATCH_KEY_DOT;
            properties.setProperty(prefix + WatchWindow.WATCH_KEY_SCOPE, null);
            properties.setProperty(prefix + WatchWindow.WATCH_KEY_EXPRESSION, null);
            properties.setProperty(prefix + WatchWindow.WATCH_KEY_NAME, null);
            properties.setProperty(prefix + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
        }

        @Override
        protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
            this.update(actionAddNewWatch, context);
            if (actionAddNewWatch.isEnabled()) {
                if (menuitemAddNewWatch == null) {
                    menuitemAddNewWatch = popup.createMenuItem((ToggleAction)actionAddNewWatch);
                }
                popup.add((Component)menuitemAddNewWatch, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForNew(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
            this.update(actionEditWatch, context);
            if (actionEditWatch.isEnabled()) {
                if (menuitemEditWatch == null) {
                    menuitemEditWatch = popup.createMenuItem((ToggleAction)actionEditWatch);
                }
                popup.add((Component)menuitemEditWatch, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionRemoveWatch, context);
            if (actionRemoveWatch.isEnabled()) {
                if (menuitemRemoveWatch == null) {
                    menuitemRemoveWatch = popup.createMenuItem((ToggleAction)actionRemoveWatch);
                }
                popup.add((Component)menuitemRemoveWatch, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
            this.update(actionRemoveAllWatches, context);
            if (actionRemoveAllWatches.isEnabled()) {
                if (menuitemRemoveAllWatches == null) {
                    menuitemRemoveAllWatches = popup.createMenuItem((ToggleAction)actionRemoveAllWatches);
                }
                popup.add((Component)menuitemRemoveAllWatches, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForData(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(actionSettings, context);
            if (actionSettings.isEnabled()) {
                if (menuitemSettings == null) {
                    menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
                }
                popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == EDIT_WATCH_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null) {
                    EvaluatorPanel.EvaluatorDataItem evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem;
                    action.setEnabled(evaluatorDataItem.canEditExpression());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == REMOVE_WATCH_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ADD_NEW_WATCH_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == REMOVE_ALL_WATCHES_CMD_ID) {
                action.setEnabled(this.canRemoveAllWatches());
                return true;
            }
            if (cmdId == SETTINGS_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == EDIT_WATCH_CMD_ID) {
                EvaluatorPanel.EvaluatorDataItem evaluatorDataItem;
                DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null && (evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem).canEditExpression()) {
                    this.editWatch(evaluatorDataItem, treePath);
                }
                return true;
            }
            if (cmdId == REMOVE_WATCH_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem) {
                    this.removeWatch(((EvaluatorPanel.EvaluatorDataItem)dataItem).ei);
                }
                return true;
            }
            if (cmdId == ADD_NEW_WATCH_CMD_ID) {
                this.addWatchDialog(null);
                return true;
            }
            if (cmdId == REMOVE_ALL_WATCHES_CMD_ID) {
                this.removeAllWatches();
                return true;
            }
            if (cmdId == SETTINGS_CMD_ID) {
                String[] path = new String[]{DbgArb.getString(673), DbgArb.getString(740)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        @Override
        protected void addDataItems() {
            EvaluatorItem[] watches = this.getWatchesForProcess(this.debuggingProcess);
            if (watches != null) {
                List root = this.getRoot();
                int length = watches.length;
                for (int i = 0; i < length; ++i) {
                    this.addDataItem(root, watches[i], false, false);
                }
            }
        }

        private List getWatchesForProject(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                Project project = debuggingProcess.getProject();
                String scope = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : WatchWindow.GlobalWatchScope;
                ArrayList list = (ArrayList)this.allWatches.get(scope);
                if (list == null) {
                    list = new ArrayList();
                    this.allWatches.put(scope, list);
                }
                return list;
            }
            return null;
        }

        private EvaluatorItem[] getWatchesForProcess(DebuggingProcess debuggingProcess) {
            List watchesForProject = this.getWatchesForProject(debuggingProcess);
            if (watchesForProject != null) {
                ArrayList<EvaluatorItem> watchesForProcess = new ArrayList<EvaluatorItem>();
                int size = watchesForProject.size();
                for (int i = 0; i < size; ++i) {
                    EvaluatorItem ei = (EvaluatorItem)watchesForProject.get(i);
                    DebuggingProcess temporary = ei.getTemporary();
                    if (temporary != debuggingProcess && temporary != null) continue;
                    watchesForProcess.add(ei);
                }
                return watchesForProcess.toArray(new EvaluatorItem[watchesForProcess.size()]);
            }
            return null;
        }

        private void editWatch(EvaluatorPanel.EvaluatorDataItem evaluatorDataItem, TreePath treePath) {
            evaluatorDataItem.editExpression(DbgArb.getString(606), DbgArb.getString(607), WatchWindow.expHistoryName, treePath);
        }

        boolean addWatchDialog(String expression) {
            String prompt;
            String title = DbgArb.getString(608);
            expression = EditWatchDialog.showEditWatchDialog(title, prompt = DbgArb.getString(609), WatchWindow.expHistoryName, expression);
            if (expression != null) {
                JDebugger.getInstance().addWatch(expression);
                return true;
            }
            return false;
        }

        EvaluatorItem addWatch(Object expression) {
            List watches = this.getWatchesForProject(this.debuggingProcess);
            if (watches != null) {
                EvaluatorItem ei = null;
                if (expression instanceof EvaluatorItem) {
                    ei = (EvaluatorItem)expression;
                } else if (expression instanceof String) {
                    ei = new EvaluatorItem((String)expression);
                }
                if (ei != null) {
                    watches.add(ei);
                    this.addDataItem(null, ei, false, false);
                    return ei;
                }
            }
            return null;
        }

        boolean removeWatch(EvaluatorItem ei) {
            List watchesForProject = this.getWatchesForProject(this.debuggingProcess);
            if (watchesForProject.remove(ei)) {
                if (ei.isPinned(this.debuggingProcess)) {
                    ei.unpin(this.debuggingProcess);
                }
                List root = this.getRoot();
                int size = root.size();
                for (int i = 0; i < size; ++i) {
                    Object o = root.get(i);
                    if (!(o instanceof EvaluatorPanel.EvaluatorDataItem) || ((EvaluatorPanel.EvaluatorDataItem)o).ei != ei) continue;
                    this.removeTopDataItem(i);
                    if (i < --size) {
                        this.selectTopDataItem(i);
                        break;
                    }
                    if (0 > --i || i >= size) break;
                    this.selectTopDataItem(i);
                    break;
                }
                return true;
            }
            return false;
        }

        private boolean canRemoveAllWatches() {
            List watches = this.getWatchesForProject(this.debuggingProcess);
            return watches != null && watches.size() > 0;
        }

        private void removeAllWatches() {
            List watches = this.getWatchesForProject(this.debuggingProcess);
            if (watches != null) {
                watches.clear();
                this.everythingChanged();
            }
        }
    }
}

