/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableTable;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.java.util.JavaCodePeek;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsPanel;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WatchWindow;

final class StackWindow
extends DebuggerWindow
implements ListSelectionListener,
Controller,
ContextMenuListener,
ColumnMenuListener {
    private List tableData;
    private JTable table;
    private StackTableCellRenderer stackTableCellRenderer;
    private StackTableModel model;
    private DebugStackFrameInfo highlightStackFrame;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private boolean skippedUpdate = true;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugThreadInfo thread;
    private int languages;
    private String title;
    private JScrollPane scrollPane;
    private StackWindowSettings stackSettings;
    private int preferredVisibleRowCount = 6;
    private static IdeAction actionPopToHere;
    private static IdeAction actionGoTo;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionBytecode;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemPopToHere;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemViewAnnotations;
    private static JMenuItem menuitemBytecode;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int POPTOHERE_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int BYTECODE_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_CLASS = 0;
    static final int COLUMN_METHOD = 1;
    static final int COLUMN_FILENAME = 2;
    static final int COLUMN_LINE = 3;
    static final int COLUMN_OFFSET = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    private TableColumn[] column = new TableColumn[5];
    private int[] columnDefaultWidth = new int[5];
    private boolean[] columnShowing = new boolean[5];
    static final String STACK_WINDOW_ID = "Debugger.StackWindow";
    private static Icon stackTabIcon;
    private static final String NOT_AVAILABLE = "";
    private boolean allowUpdateDataWindows = true;
    private JPanel stackPanel;
    private JComboBox threadBox;
    private boolean ignoreThreadBox;
    private Toolbar toolbar;
    private boolean adjustColumnsAlreadyDone = false;

    StackWindow() {
        super(STACK_WINDOW_ID);
        this.title = DbgArb.getString(245);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        StackWindow.makeActions();
        this.setControllerForActions();
    }

    void setLocalsWindow(LocalsWindow localsWindow) {
        this.localsWindow = localsWindow;
        this.updateData(localsWindow);
    }

    void setWatchWindow(WatchWindow watchWindow) {
        this.watchWindow = watchWindow;
        this.updateData(watchWindow);
    }

    void newInspectorWindow(InspectorWindow inspectorWindow) {
        this.updateData(inspectorWindow);
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.WEST;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        for (int i = 0; i < 5; ++i) {
            int width = this.stackSettings.getColumnWidth(i);
            if (width == 0) continue;
            this.adjustColumnsAlreadyDone = true;
            this.column[i].setPreferredWidth(width);
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String order = this.stackSettings.getColumnOrder();
        if (order != null) {
            for (int i = 0; i < 5; ++i) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from == i) continue;
                    this.table.moveColumn(from, i);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    void stackWindowSettingsChanged(boolean changed) {
        if (this.table == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            boolean show = this.stackSettings.getColumnVisible(i);
            if (this.columnShowing[i] == show) continue;
            this.columnShowing[i] = show;
            if (show) {
                this.table.addColumn(this.column[i]);
                continue;
            }
            this.table.removeColumn(this.column[i]);
        }
        if (changed && this.table.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackWindow.this.updateColumn(0);
                }
            });
        }
        Dimension d = this.table.getPreferredSize();
        d.height = this.table.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.table.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    private void saveSettings() {
        if (this.table == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            this.stackSettings.setColumnWidth(i, this.column[i].getWidth());
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String order = NOT_AVAILABLE;
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.stackSettings.setColumnOrder(order);
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        StackWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPopToHere), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBytecode), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(256), null, (Integer)DbgArb.getInteger(257), null, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(258), null, (Integer)DbgArb.getInteger(259), null, null, (boolean)false);
            actionViewAnnotations.setEnabled(false);
            actionBytecode = IdeAction.get((int)BYTECODE_CMD_ID, null, (String)DbgArb.getString(260), null, (Integer)DbgArb.getInteger(261), null, null, (boolean)false);
            actionBytecode.setEnabled(false);
            actionPopToHere = IdeAction.get((int)POPTOHERE_CMD_ID, null, (String)DbgArb.getString(262), null, (Integer)DbgArb.getInteger(263), null, null, (boolean)false);
            actionPopToHere.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(102), null, (Integer)RunMgrArb.getInteger(103), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(100), null, (Integer)RunMgrArb.getInteger(101), null, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionViewAnnotations, actionBytecode, actionPopToHere, actionSettings, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    public Component getGUI() {
        if (this.stackPanel == null) {
            this.stackSettings = StackWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.stackWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.stackSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        StackWindow.this.stackWindowSettingsChanged(true);
                    }
                }
            });
        }
        return this.stackPanel;
    }

    public Toolbar getToolbar() {
        if (!Product.isRaptor()) {
            if (this.toolbar == null) {
                this.createThreadBox();
                this.toolbar = new Toolbar();
                this.toolbar.add((Component)this.threadBox);
            }
            return this.toolbar;
        }
        return super.getToolbar();
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_stackwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        DebugStackFrameInfo info;
        StackItem stackItem = this.getSelectedStackItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (stackItem != null && (info = stackItem.getStackFrameInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)((Object)info);
        }
        return ContextBuilder.buildContext((Element)stackItem, (View)this, event, this.debuggingProcess, jdiInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        return visible ? 5 : 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (stackTabIcon == null) {
            stackTabIcon = OracleIcons.getIcon((String)"debugger/stack.png");
        }
        return stackTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.table.isShowing()) {
            this.highlightStackFrame = this.getSelectedStackFrameInfo();
            this.updateData();
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showInSource();
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.viewAnnotations();
            }
            return true;
        }
        if (cmdId == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showBytecode();
            }
            return true;
        }
        if (cmdId == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.popToHere();
            }
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(673), DbgArb.getString(713)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null && (column = this.table.getSelectedColumn()) != -1 && (o = stackItem.getValueOfColumn(column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.table == null || !this.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(this.table.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canViewAnnotations());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canShowBytecode());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canPopToHere());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            StackItem stackItem = this.getSelectedStackItem();
            int column = this.table.getSelectedColumn();
            action.setEnabled(stackItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.table != null && (Helpers.contextMatchesSource(context, this.table) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                this.addPopupMenuItemsForStackItem(popup, context);
            }
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void showColumn(int index) {
        this.columnShowing[index] = true;
        if (this.stackSettings != null) {
            this.stackSettings.setColumnVisible(index, true);
        }
        this.table.addColumn(this.column[index]);
    }

    @Override
    public void hideColumn(int index) {
        this.columnShowing[index] = false;
        if (this.stackSettings != null) {
            this.stackSettings.setColumnVisible(index, false);
        }
        this.table.removeColumn(this.column[index]);
    }

    private void createGUI() {
        this.tableData = new ArrayList();
        this.model = new StackTableModel();
        this.table = new PeekableStackTable(this.model);
        this.table.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.table.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.table.setFocusTraversalKeys(0, emptySet);
        this.table.setFocusTraversalKeys(1, emptySet);
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 5; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
        }
        boolean[] showColumnInMenu = new boolean[5];
        Arrays.fill(showColumnInMenu, true);
        if (Product.isRaptor()) {
            showColumnInMenu[0] = false;
            showColumnInMenu[4] = false;
        }
        JDebugger.addColumnsMenu(this.table, this, showColumnInMenu);
        this.columnDefaultWidth[3] = this.columnDefaultWidth[3] / 2;
        this.column[3].setPreferredWidth(this.columnDefaultWidth[3]);
        this.columnDefaultWidth[4] = this.columnDefaultWidth[4] / 2;
        this.column[4].setPreferredWidth(this.columnDefaultWidth[4]);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        this.stackTableCellRenderer = new StackTableCellRenderer();
        this.table.setDefaultRenderer(String.class, this.stackTableCellRenderer);
        JTableHeader tableHeader = this.table.getTableHeader();
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    int modelColumn = table.convertColumnIndexToModel(column);
                    int horizontalAlignment = 2;
                    if (modelColumn == 3 || modelColumn == 4) {
                        horizontalAlignment = 4;
                    }
                    defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StackWindow.this.debuggingProcess == null || !StackWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(326, StackWindow.this.getTitleName()));
                }
                if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                    Context context = StackWindow.this.getContext(e);
                    StackWindow.this.update(actionGoTo, context);
                    if (actionGoTo.isEnabled()) {
                        StackWindow.this.handleEvent(actionGoTo, context);
                    }
                }
            }
        });
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StackWindow.this.debuggingProcess == null || !StackWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(326, StackWindow.this.getTitleName()));
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: {
                        Context context = StackWindow.this.getContext(e);
                        StackWindow.this.update(actionGoTo, context);
                        if (!actionGoTo.isEnabled()) break;
                        StackWindow.this.handleEvent(actionGoTo, context);
                        e.consume();
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        Color background = this.table.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StackWindow.this.debuggingProcess == null || !StackWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(326, StackWindow.this.getTitleName()));
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StackWindow.this.adjustColumnsAfterResize();
            }
        });
        this.table.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && StackWindow.this.table.isShowing()) {
                    StackWindow.this.nowShown();
                }
            }
        });
        this.stackPanel = new JPanel(new BorderLayout());
        this.stackPanel.add((Component)this.scrollPane, "Center");
        if (!Product.isRaptor()) {
            this.stackPanel.add((Component)this.getToolbar(), "North");
        }
    }

    private void createThreadBox() {
        if (!Product.isRaptor()) {
            this.threadBox = new JComboBox();
            JTextField threadBoxEditor = (JTextField)this.threadBox.getEditor().getEditorComponent();
            threadBoxEditor.getAccessibleContext().setAccessibleName(DbgArb.getString(908));
            this.threadBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof ThreadItem) {
                        this.setText(((ThreadItem)value).name);
                        this.setIcon(((ThreadItem)value).icon);
                    }
                    return c;
                }
            });
            this.threadBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object selectedItem;
                    if (!StackWindow.this.isIgnoreThreadBox() && e.getStateChange() == 1 && (selectedItem = e.getItem()) instanceof ThreadItem) {
                        StackWindow.this.thread = ((ThreadItem)selectedItem).info;
                        StackWindow.this.highlightStackFrame = null;
                        StackWindow.this.updateModel();
                    }
                }
            });
        }
    }

    private boolean isIgnoreThreadBox() {
        return this.ignoreThreadBox;
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, this.table);
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.table);
    }

    private void addPopupMenuItemsForStackItem(ContextMenu popup, Context context) {
        this.update(actionPopToHere, context);
        if (actionPopToHere.isEnabled()) {
            if (menuitemPopToHere == null) {
                menuitemPopToHere = popup.createMenuItem((ToggleAction)actionPopToHere);
            }
            popup.add((Component)menuitemPopToHere, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionViewAnnotations, context);
        if (actionViewAnnotations.isEnabled()) {
            if (menuitemViewAnnotations == null) {
                menuitemViewAnnotations = popup.createMenuItem((ToggleAction)actionViewAnnotations);
            }
            popup.add((Component)menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionBytecode, context);
        if (actionBytecode.isEnabled()) {
            if (menuitemBytecode == null) {
                menuitemBytecode = popup.createMenuItem((ToggleAction)actionBytecode);
            }
            popup.add((Component)menuitemBytecode, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    private void selectRow(int row) {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel.addSelectionInterval(row, row);
    }

    private void saveToFile() {
        ThreadsPanel.threadDump(new DebugThreadInfo[]{this.thread}, this.debuggingProcess, this.getContext(), RunMgrArb.format(104, this.getTitleName()), this.getTitleName());
    }

    private void nowShown() {
        if (this.skippedUpdate && this.table.isEnabled()) {
            this.updateModel();
        }
    }

    void everythingChanged() {
        this.highlightStackFrame = null;
        this.updateModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStack(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread) {
        block14: {
            this.debuggingProcess = debuggingProcess;
            this.vm = vm;
            this.thread = thread;
            if (this.threadBox != null) {
                this.ignoreThreadBox = true;
                try {
                    if (vm != null) {
                        DebugThreadInfo[] currentThreads = vm.listThreads();
                        Arrays.sort(currentThreads, new Comparator<DebugThreadInfo>(){

                            @Override
                            public int compare(DebugThreadInfo o1, DebugThreadInfo o2) {
                                return o1.getName().compareToIgnoreCase(o2.getName());
                            }
                        });
                        JComboBox jComboBox = this.threadBox;
                        synchronized (jComboBox) {
                            int threadCount = this.threadBox.getItemCount();
                            ThreadItem selectedItem = null;
                            for (DebugThreadInfo currentThread : currentThreads) {
                                ThreadItem threadItem = new ThreadItem(currentThread, debuggingProcess);
                                this.threadBox.addItem(threadItem);
                                if (thread == null || !thread.getName().equalsIgnoreCase(currentThread.getName())) continue;
                                selectedItem = threadItem;
                            }
                            for (int x = threadCount - 1; x >= 0; --x) {
                                this.threadBox.removeItemAt(x);
                            }
                            if (selectedItem != null) {
                                this.threadBox.setSelectedItem(selectedItem);
                            }
                            break block14;
                        }
                    }
                    if (this.threadBox == null) break block14;
                    JComboBox jComboBox = this.threadBox;
                    synchronized (jComboBox) {
                        this.threadBox.removeAllItems();
                    }
                }
                finally {
                    this.ignoreThreadBox = false;
                }
            }
        }
        this.highlightStackFrame = null;
        this.updateModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModel() {
        if (this.table == null) {
            return;
        }
        this.allowUpdateDataWindows = false;
        try {
            this.stackTableCellRenderer.clear();
            DebugStackFrameInfo saveHighlightFrame = this.highlightStackFrame;
            this.table.getSelectionModel().clearSelection();
            this.highlightStackFrame = saveHighlightFrame;
            if (this.highlightStackFrame == null && this.thread != null) {
                this.highlightStackFrame = this.thread.getStackFrame(0);
            }
            this.table.setEnabled(true);
            if (this.table.isShowing()) {
                this.skippedUpdate = false;
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    int languages = this.vm.getLanguages();
                    if (this.languages != languages) {
                        this.languages = languages;
                        for (int i = 0; i < 5; ++i) {
                            this.column[i].setHeaderValue(this.model.getColumnName(i));
                        }
                        this.table.getTableHeader().repaint();
                    }
                    DebugStackFrameInfo[] frames = this.thread != null ? this.thread.listStack() : new DebugStackFrameInfo[]{};
                    int framesLength = frames.length;
                    ArrayList<StackItem> stackItems = new ArrayList<StackItem>();
                    for (int i = 0; i < framesLength; ++i) {
                        stackItems.add(new StackItem(frames[i]));
                    }
                    saveHighlightFrame = this.highlightStackFrame;
                    this.updateTable(stackItems);
                    this.highlightStackFrame = saveHighlightFrame;
                    if (this.highlightStackFrame != null) {
                        int row = this.highlightStackFrame.getFrameNumber();
                        this.selectRow(row);
                    }
                } else {
                    this.updateTable(new ArrayList());
                }
            } else {
                this.skippedUpdate = true;
            }
        }
        finally {
            this.allowUpdateDataWindows = true;
        }
        this.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStack() {
        if (this.table == null) {
            return;
        }
        this.table.setEnabled(false);
        int size = this.tableData.size();
        for (int row = 0; row < size; ++row) {
            StackItem stackItem = (StackItem)this.tableData.get(row);
            stackItem.clearStack();
        }
        this.vm = null;
        this.thread = null;
        if (this.threadBox != null) {
            this.ignoreThreadBox = true;
            try {
                JComboBox jComboBox = this.threadBox;
                synchronized (jComboBox) {
                    int threadCount = this.threadBox.getItemCount();
                    int selectedIndex = this.threadBox.getSelectedIndex();
                    for (int i = threadCount - 1; i >= 0; --i) {
                        if (i == selectedIndex) continue;
                        this.threadBox.removeItemAt(i);
                    }
                }
            }
            finally {
                this.ignoreThreadBox = false;
            }
        }
        this.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            if (this.threadBox != null) {
                this.ignoreThreadBox = true;
                try {
                    JComboBox jComboBox = this.threadBox;
                    synchronized (jComboBox) {
                        this.threadBox.removeAllItems();
                    }
                }
                finally {
                    this.ignoreThreadBox = false;
                }
            }
            this.highlightStackFrame = null;
            this.table.setEnabled(true);
            this.updateTable(new ArrayList());
        }
        if (this.localsWindow != null) {
            this.localsWindow.processFinished(debuggingProcess);
        }
        if (this.watchWindow != null) {
            this.watchWindow.processFinished(debuggingProcess);
        }
        Iterator i = JDebugger.getInstance().getInspectorWindows();
        while (i.hasNext()) {
            InspectorWindow inspectorWindow = (InspectorWindow)i.next();
            inspectorWindow.processFinished(debuggingProcess);
        }
    }

    private void updateData() {
        if (this.vm != null) {
            this.vm.setCurrentStackFrame(this.highlightStackFrame);
        }
        if (this.allowUpdateDataWindows) {
            this.updateDebuggerExtenders();
            long milliTime = System.currentTimeMillis();
            this.updateData(this.localsWindow);
            if (JDebugger.logger.isEnabled()) {
                JDebugger.logger.trace("Data window update in " + (System.currentTimeMillis() - milliTime) + " msecs");
            }
            this.updateData(this.watchWindow);
            Iterator i = JDebugger.getInstance().getInspectorWindows();
            while (i.hasNext()) {
                InspectorWindow inspectorWindow = (InspectorWindow)i.next();
                this.updateData(inspectorWindow);
            }
            this.updateCustomWindows();
        }
    }

    void updateEvaluator(Evaluator evaluator) {
        if (this.table.isEnabled() && this.debuggingProcess != null && this.vm != null && this.thread != null) {
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
        } else {
            evaluator.setDebugContext(null, null, null);
        }
    }

    private void updateData(UpdateableDataWindow updateableDataWindow) {
        if (updateableDataWindow != null) {
            if (this.table != null && this.table.isEnabled()) {
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    updateableDataWindow.updateData(this.debuggingProcess, this.vm, this.thread, this.highlightStackFrame);
                } else {
                    updateableDataWindow.updateData(null, null, null, null);
                }
            } else {
                updateableDataWindow.clearData();
            }
        }
    }

    private void updateDebuggerExtenders() {
        if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
            JDebugger.getInstance().setDebuggerExtendersEvaluator(this.debuggingProcess, evaluator);
        }
    }

    private void updateCustomWindows() {
        if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
            JDebugger.getInstance().refreshCustomWindows(evaluator, this.debuggingProcess);
        }
    }

    private void updateTable(List stackItems) {
        this.tableData = stackItems;
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void updateColumn(int column) {
        this.clearCacheForColumn(column);
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, this.tableData.size() - 1, column));
    }

    void clearCacheForColumn(int column) {
        int size = this.tableData.size();
        for (int row = 0; row < size; ++row) {
            StackItem stackItem = (StackItem)this.tableData.get(row);
            stackItem.clearCacheForColumn(column);
        }
    }

    private StackItem getSelectedStackItem() {
        int row;
        if (this.table != null && 0 <= (row = this.table.getSelectedRow()) && row < this.tableData.size()) {
            return (StackItem)this.tableData.get(row);
        }
        return null;
    }

    private DebugStackFrameInfo getSelectedStackFrameInfo() {
        StackItem stackItem = this.getSelectedStackItem();
        if (stackItem != null) {
            return stackItem.getStackFrameInfo();
        }
        return null;
    }

    static {
        POPTOHERE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackPopToHere");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackGoTo");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackViewAnnotations");
        BYTECODE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackBytecode");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSettings");
        stackTabIcon = null;
    }

    private class ThreadItem {
        DebugThreadInfo info;
        String name;
        Icon icon;

        ThreadItem(DebugThreadInfo info, DebuggingProcess debuggingProcess) {
            this.info = info;
            StringBuilder buf = new StringBuilder();
            buf.append(info.getName());
            buf.append(" (");
            buf.append(ThreadsPanel.getThreadStatus(debuggingProcess, info));
            buf.append(')');
            this.name = buf.toString();
            this.icon = ThreadsPanel.getThreadStatusIcon(debuggingProcess, info);
        }
    }

    private class PeekableStackTable
    extends PeekableTable {
        PeekableStackTable(TableModel model) {
            super(model);
        }

        public Peek createPeek(int row, int col) {
            StackItem item = (StackItem)StackWindow.this.tableData.get(row);
            if (item.canShowInSource() && item.getLine().length() > 0) {
                String fqName = item.getStackFrameInfo().getLocation().getClassInfo().getName();
                JavaManager jMan = JavaManager.getInstance((Project)StackWindow.this.debuggingProcess.getProject());
                URL url = jMan.getJavaClassLocator().getSourceURL(fqName);
                if (url == null) {
                    return null;
                }
                Rectangle rect = this.getCellRect(row, 0, true);
                rect.add(this.getCellRect(row, this.getColumnCount() - 1, true));
                CodePeek peek = JavaCodePeek.createCodePeek((Project)StackWindow.this.debuggingProcess.getProject(), (URL)url, (int)Integer.parseInt(item.getLine()), (String)(fqName + " " + item.getLongLabel()), (JComponent)((Object)this), (Rectangle)rect, (String)"execution-point");
                return peek;
            }
            return null;
        }
    }

    private final class StackItem
    extends BaseElement {
        private DebugStackFrameInfo stackFrame;
        private DebugLocation location;
        private DebugClassInfo clazz;
        private DebugMethodInfo method;
        private String filename;
        private int line;
        private int bc;
        private String cachedMethodName;
        private String cachedClassName;

        StackItem(DebugStackFrameInfo stackFrame) {
            this.stackFrame = stackFrame;
            this.location = stackFrame.getLocation();
            if (this.location != null) {
                this.clazz = this.location.getClassInfo();
                this.method = this.location.getMethod();
                this.filename = this.location.getFilename();
                if (Product.isRaptor() && this.filename != null && this.filename.endsWith(".pls")) {
                    this.filename = this.filename.substring(0, this.filename.length() - 4);
                }
                this.line = this.location.getLine();
                this.bc = this.location.getBytecodeOffset();
            }
            this.setIcon(OracleIcons.getIcon((String)"method.png"));
        }

        void clearStack() {
            this.stackFrame = null;
            this.location = null;
            this.clazz = null;
            this.method = null;
        }

        void clearCacheForColumn(int column) {
            switch (column) {
                case 0: {
                    this.cachedClassName = null;
                    break;
                }
                case 1: {
                    this.cachedMethodName = null;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }

        Object getValueOfColumn(int column) {
            switch (column) {
                case 0: {
                    return this.getClassName();
                }
                case 1: {
                    return this.getMethodName();
                }
                case 2: {
                    return this.getFilename();
                }
                case 3: {
                    return this.getLine();
                }
                case 4: {
                    return this.getOffset();
                }
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getToolTip(int column) {
            String tooltip = null;
            if (!Product.isRaptor()) {
                switch (column) {
                    case 0: {
                        if (this.clazz == null) break;
                        tooltip = DebugShared.makeCourtesyClassName(this.clazz, true);
                        break;
                    }
                    case 1: {
                        if (this.method == null) break;
                        tooltip = DebugShared.makeCourtesyMethodName(this.method, false, true, this.stackFrame);
                    }
                }
            }
            if (tooltip == null) {
                tooltip = (String)this.getValueOfColumn(column);
            }
            if (tooltip != null && tooltip.length() > 0) {
                return tooltip;
            }
            return null;
        }

        @Override
        public String getShortLabel() {
            return this.getMethodName();
        }

        @Override
        public Object getData() {
            return this;
        }

        DebugStackFrameInfo getStackFrameInfo() {
            return this.stackFrame;
        }

        String getClassName() {
            if (this.cachedClassName == null && StackWindow.this.table.isEnabled() && this.clazz != null) {
                this.cachedClassName = DebugShared.makeCourtesyClassName(this.clazz, StackWindow.this.stackSettings.isShowPackages());
            }
            if (this.cachedClassName != null) {
                return this.cachedClassName;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getMethodName() {
            if (this.cachedMethodName == null && StackWindow.this.table.isEnabled()) {
                if (Product.isRaptor()) {
                    int thirdDot;
                    int secondDot;
                    String className;
                    int firstDot;
                    if (this.stackFrame != null && this.stackFrame.getLanguage() == 2 && this.clazz != null && this.method != null && (firstDot = (className = this.clazz.getName()).indexOf(".")) != -1 && (secondDot = className.indexOf(".", 8)) != -1 && (thirdDot = className.indexOf(".", secondDot + 1)) != -1) {
                        String type = className.substring(firstDot + 1, secondDot);
                        String schemaDotBodyDotSubroutine = className.substring(secondDot + 1, thirdDot) + ".";
                        if (type.equals("Block")) {
                            schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + DbgArb.getString(252);
                        } else {
                            if (type.equals("PackageBody") || type.equals("TypeBody")) {
                                String body = className.substring(thirdDot + 1);
                                schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + body + ".";
                            }
                            schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + this.method.getNameWithoutClassOrSignature();
                        }
                        this.cachedMethodName = schemaDotBodyDotSubroutine;
                    }
                    if (this.cachedMethodName == null && this.method != null) {
                        this.cachedMethodName = this.method.getNameWithoutSignature();
                    }
                } else if (this.method != null) {
                    this.cachedMethodName = DebugShared.makeCourtesyMethodName(this.method, false, false, this.stackFrame);
                }
            }
            if (this.cachedMethodName != null) {
                return this.cachedMethodName;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getFilename() {
            if (this.filename != null) {
                return this.filename;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getLine() {
            if (this.line > 0) {
                return Integer.toString(this.line);
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getOffset() {
            if (this.bc >= 0) {
                return Integer.toString(this.bc);
            }
            return StackWindow.NOT_AVAILABLE;
        }

        boolean canShowInSource() {
            if (this.stackFrame != null && this.stackFrame.getFrameNumber() == 0 && StackWindow.this.debuggingProcess != null && StackWindow.this.debuggingProcess.canDebuggerExtenderShowIPLocation()) {
                return true;
            }
            return this.location != null || this.clazz != null;
        }

        void showInSource() {
            if (this.stackFrame != null && this.stackFrame.getFrameNumber() == 0 && StackWindow.this.debuggingProcess != null && StackWindow.this.debuggingProcess.debuggerExtenderShowIPLocation()) {
                return;
            }
            if (this.location != null) {
                StackWindow.this.debuggingProcess.showSourceFile(this.location, true);
            } else if (this.clazz != null) {
                StackWindow.this.debuggingProcess.showSourceFile(this.clazz);
            }
        }

        boolean canViewAnnotations() {
            return this.method instanceof DebugHasAnnotations && ((DebugHasAnnotations)((Object)this.method)).countAnnotations() > 0;
        }

        void viewAnnotations() {
            if (this.method instanceof DebugHasAnnotations) {
                DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)((Object)this.method)).getAnnotations();
                String methodName = this.getMethodName();
                String dlgTitle = DbgArb.format(864, methodName);
                DataPanel.showAnnotationsDialog(dlgTitle, null, StackWindow.this.debuggingProcess, StackWindow.this.vm, StackWindow.this.thread, this.stackFrame, annotations);
            }
        }

        boolean canPopToHere() {
            if (StackWindow.this.debuggingProcess != null && StackWindow.this.vm != null && StackWindow.this.thread != null && StackWindow.this.vm.getCapabilities().canPopFrames() && this.stackFrame != null && this.stackFrame.getFrameNumber() != 0) {
                for (int row = StackWindow.this.tableData.indexOf(this); row >= 0; --row) {
                    StackItem stackItem = (StackItem)StackWindow.this.tableData.get(row);
                    if (stackItem.method == null) {
                        return false;
                    }
                    if ((stackItem.method.getAccess() & 0x100) == 0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        void popToHere() {
            if (this.canPopToHere()) {
                this.stackFrame.popBackToHere();
                StackWindow.this.debuggingProcess.stackFramesPopped(StackWindow.this.thread);
            }
        }

        boolean canShowBytecode() {
            return StackWindow.this.vm != null && StackWindow.this.vm.getCapabilities().canDisassembleMethod() && this.stackFrame != null && this.method != null && this.stackFrame.getLanguage() == 1;
        }

        void showBytecode() {
            if (this.canShowBytecode()) {
                StackWindow.this.debuggingProcess.showBytecode(this.method, this.bc);
            }
        }
    }

    private final class StackTableModel
    extends AbstractTableModel {
        private StackTableModel() {
        }

        @Override
        public int getRowCount() {
            return StackWindow.this.tableData.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    if (StackWindow.this.languages == 8) {
                        return DbgArb.getString(853);
                    }
                    if (StackWindow.this.languages == 4) {
                        return DbgArb.getString(248);
                    }
                    return DbgArb.getString(247);
                }
                case 1: {
                    if (Product.isRaptor()) {
                        return DbgArb.getString(251);
                    }
                    if (StackWindow.this.languages == 8) {
                        return DbgArb.getString(854);
                    }
                    if (StackWindow.this.languages == 4) {
                        return DbgArb.getString(250);
                    }
                    return DbgArb.getString(249);
                }
                case 2: {
                    return DbgArb.getString(253);
                }
                case 3: {
                    return DbgArb.getString(254);
                }
                case 4: {
                    return DbgArb.getString(255);
                }
            }
            return StackWindow.NOT_AVAILABLE;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                StackItem stackItem = (StackItem)StackWindow.this.tableData.get(row);
                return stackItem.getValueOfColumn(column);
            }
            catch (Exception e) {
                e.printStackTrace();
                return StackWindow.NOT_AVAILABLE;
            }
        }

        private String getAccessibleNameAt(int row, int column) {
            int id = 246;
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(row, column);
            if (value.length() == 0) {
                value = DbgArb.getString(842);
            }
            return DbgArb.format(id, columnName, value);
        }
    }

    class StackTableCellRenderer
    extends DefaultTableCellRenderer {
        private StackItem stackItem;
        private int modelColumn;

        StackTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.stackItem = (StackItem)StackWindow.this.tableData.get(row);
            this.modelColumn = table.convertColumnIndexToModel(column);
            int horizontalAlignment = 2;
            if (this.modelColumn == 3 || this.modelColumn == 4) {
                horizontalAlignment = 4;
            }
            this.setHorizontalAlignment(horizontalAlignment);
            if (column == 0) {
                this.setIcon(this.stackItem.getIcon());
            } else {
                this.setIcon(null);
            }
            AccessibleContext ac = this.getAccessibleContext();
            String accessibleName = StackWindow.this.model.getAccessibleNameAt(row, this.modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            return this;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.stackItem.getToolTip(this.modelColumn);
        }

        void clear() {
            this.stackItem = null;
        }
    }
}

