/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

public final class SmartWindowSettingsPanel
extends DefaultTraversablePanel {
    private DataPanelSettingsPanel dataPanel = new DataPanelSettingsPanel();
    private JCheckBox sortExpressionsCheckBox = new JCheckBox();
    private JLabel locationsLabel = new JLabel();
    private NumericSpinBox locationsBox = new NumericSpinBox(1, 10);
    private JLabel linesLabel = new JLabel();
    private NumericSpinBox linesBox = new NumericSpinBox(1, 10);
    private JLabel spacerLabel = new JLabel();

    public SmartWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_smartdatawinsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.sortExpressionsCheckBox, (String)DbgArb.getString(742));
        ResourceUtils.resLabel((JLabel)this.locationsLabel, (Component)this.locationsBox, (String)DbgArb.getString(743));
        ResourceUtils.resLabel((JLabel)this.linesLabel, (Component)this.linesBox, (String)DbgArb.getString(744));
        SpinBuddy buddy = this.locationsBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        if ((buddy = this.linesBox.getSpinBuddy()) instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        this.spacerLabel.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets borderInsets = new Insets(0, 0, 0, 0);
        this.add(this.dataPanel.makeChooseColumnsPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.insets.top = 8;
        this.add(this.dataPanel.makeSortPanel(this.sortExpressionsCheckBox), constraints);
        ++constraints.gridy;
        this.add(this.dataPanel.makeShowPanel(null), constraints);
        ++constraints.gridy;
        this.add(this.dataPanel.makeHidePanel(null), constraints);
        ++constraints.gridy;
        this.add(this.makeSmartPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add(this.spacerLabel, constraints);
    }

    private JPanel makeSmartPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        int y = 0;
        panel.add((Component)this.locationsLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.locationsBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.linesLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
        panel.add((Component)this.linesBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(2, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private SmartWindowSettings getData(TraversableContext tc) {
        return SmartWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        SmartWindowSettings settings = this.getData(tc);
        this.dataPanel.onEntry(settings.getDataPanelSettings());
        this.sortExpressionsCheckBox.setSelected(settings.isSortExpressions());
        this.locationsBox.setIntValue(settings.getNumberOfLocations());
        this.linesBox.setIntValue(settings.getNumberOfLines());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        SmartWindowSettings settings = this.getData(tc);
        this.dataPanel.onExit(settings.getDataPanelSettings());
        settings.setSortExpressions(this.sortExpressionsCheckBox.isSelected());
        try {
            int numberOfLocations = this.locationsBox.getIntValue();
            settings.setNumberOfLocations(numberOfLocations);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int numberOfLines = this.linesBox.getIntValue();
            settings.setNumberOfLines(numberOfLines);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

