/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocationInfo;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

final class SmartWindow
extends DataWindow {
    private SmartWindowSettings smartWindowSettings = SmartWindowSettings.getInstance();
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String SMART_WINDOW_ID = "Debugger.SmartWindow";
    private static Icon smartTabIcon;

    SmartWindow() {
        super(SMART_WINDOW_ID, DbgArb.getString(610), "f1_deb_smartdatawindow_html");
        SmartWindow.makeActions();
        this.setDataPanel(new SmartPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        if (smartTabIcon == null) {
            smartTabIcon = OracleIcons.getIcon((String)"debugger/smrtdata.png");
        }
        return smartTabIcon;
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        return super.getDefaultVisibility(layout) | 4;
    }

    void refreshWindow() {
        ((SmartPanel)this.dataPanel).refreshWindow();
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        SmartWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(286), null, (Integer)DbgArb.getInteger(287), null, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(280), null, (Integer)DbgArb.getInteger(283), null, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(280));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(284), null, (Integer)DbgArb.getInteger(285), null, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(288), null, (Integer)DbgArb.getInteger(289), null, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(290), null, (Integer)DbgArb.getInteger(291), null, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(292), null, (Integer)DbgArb.getInteger(293), null, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(296), null, (Integer)DbgArb.getInteger(297), null, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(298), null, (Integer)DbgArb.getInteger(299), null, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(312), null, (Integer)DbgArb.getInteger(313), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(314), null, (Integer)DbgArb.getInteger(315), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(300), null, (Integer)DbgArb.getInteger(302), null, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(300));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(303), null, (Integer)DbgArb.getInteger(305), null, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(303));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(306), null, (Integer)DbgArb.getInteger(308), null, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(306));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(316), null, (Integer)DbgArb.getInteger(317), null, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(318, ""), null, (Integer)DbgArb.getInteger(319), null, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(102), null, (Integer)RunMgrArb.getInteger(103), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(100), null, (Integer)RunMgrArb.getInteger(101), null, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartSettings");
        smartTabIcon = null;
    }

    final class SmartPanel
    extends EvaluatorPanel {
        private Map map;
        private List<String> lastExpressions;
        private boolean createNewExpressions;

        SmartPanel() {
            super(SmartWindow.this, SmartWindow.this.smartWindowSettings.getDataPanelSettings());
            this.createNewExpressions = true;
            this.map = new HashMap();
            this._actionPin = null;
            this._actionUnpin = null;
            this._actionViewWhole = actionViewWhole;
            this._actionViewAnnotations = actionViewAnnotations;
            this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
            this._actionAdjustRange = actionAdjustRange;
            this._actionToggleValue = actionToggleValue;
            this._actionModifyValue = actionModifyValue;
            this._actionWatch = actionWatch;
            this._actionInspect = actionInspect;
            this._actionWatchClassLoader = actionWatchClassLoader;
            this._actionInspectClassLoader = actionInspectClassLoader;
            this._actionGoto = actionGoto;
            this._actionGotoDeclared = actionGotoDeclared;
            this._actionGotoField = actionGotoField;
            this._actionUseFilters = actionUseFilters;
            this._actionObjectPreferences = actionObjectPreferences;
            this._actionCollapseAll = actionCollapseAll;
            this._actionSave = actionSave;
            this._PIN_CMD_ID = -1;
            this._UNPIN_CMD_ID = -1;
            this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
            this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
            this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
            this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
            this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
            this._WATCH_CMD_ID = WATCH_CMD_ID;
            this._INSPECT_CMD_ID = INSPECT_CMD_ID;
            this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
            this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
            this._GOTO_CMD_ID = GOTO_CMD_ID;
            this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
            this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
            this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
            this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
            this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
            this._SAVE_CMD_ID = SAVE_CMD_ID;
        }

        @Override
        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(actionSettings, context);
            if (actionSettings.isEnabled()) {
                if (menuitemSettings == null) {
                    menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
                }
                popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == SETTINGS_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == SETTINGS_CMD_ID) {
                String[] path = new String[]{DbgArb.getString(673), DbgArb.getString(741)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        @Override
        void processFinished(DebuggingProcess debuggingProcess) {
            super.processFinished(debuggingProcess);
            this.map.remove(debuggingProcess);
        }

        @Override
        public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
            this.createNewExpressions = true;
            this.lastExpressions = null;
            this.updateDataImpl(debuggingProcess, vm, thread, frame);
        }

        private void updateDataImpl(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
            if (debuggingProcess != null && vm != null && thread != null && frame != null && !this.sameAsLastFrame(debuggingProcess, frame)) {
                this.insertCurrent(debuggingProcess, vm, thread, frame);
            }
            super.updateData(debuggingProcess, vm, thread, frame);
        }

        void refreshWindow() {
            this.updateDataImpl(this.debuggingProcess, this.vm, this.thread, this.thread.getStackFrame(0));
        }

        private boolean sameAsLastFrame(DebuggingProcess debuggingProcess, DebugStackFrameInfo frame) {
            LocationInfo lastInfo;
            List listOfInfo = (List)this.map.get(debuggingProcess);
            return listOfInfo != null && listOfInfo.size() > 0 && (lastInfo = (LocationInfo)listOfInfo.get(0)).isSameFrame(frame);
        }

        private void insertCurrent(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
            ArrayList<LocationInfo> listOfInfo = (ArrayList<LocationInfo>)this.map.get(debuggingProcess);
            if (listOfInfo == null) {
                listOfInfo = new ArrayList<LocationInfo>();
                this.map.put(debuggingProcess, listOfInfo);
            }
            LocationInfo info = new LocationInfo(debuggingProcess, frame);
            listOfInfo.add(0, info);
            int max = 10;
            while (listOfInfo.size() > 10) {
                listOfInfo.remove(10);
            }
        }

        private List<String> getExpressions(DebuggingProcess debuggingProcess) {
            int listSize;
            ArrayList<String> expressions = new ArrayList<String>();
            List listOfInfo = (List)this.map.get(debuggingProcess);
            if (listOfInfo != null && (listSize = listOfInfo.size()) > 0) {
                LocationInfo info;
                int i;
                int numLocations = SmartWindow.this.smartWindowSettings.getNumberOfLocations();
                ArrayList<LocationInfo> locations = new ArrayList<LocationInfo>();
                int count = 0;
                LocationInfo currentInfo = (LocationInfo)listOfInfo.get(0);
                DebugMethodInfo currentMethod = currentInfo.getMethod();
                locations.add(currentInfo);
                if (++count < numLocations) {
                    for (i = 1; i < listSize; ++i) {
                        info = (LocationInfo)listOfInfo.get(i);
                        DebugMethodInfo method = info.getMethod();
                        if (!ModelUtil.areEqual((Object)method, (Object)currentMethod)) continue;
                        locations.add(info);
                        if (++count >= numLocations) break;
                    }
                }
                for (i = count - 1; i >= 0; --i) {
                    info = (LocationInfo)locations.get(i);
                    List infoExpressions = info.getExpressions(SmartWindow.this.smartWindowSettings, this.vm, this.thread, this.frame);
                    if (infoExpressions == null) continue;
                    int size = infoExpressions.size();
                    for (int e = 0; e < size; ++e) {
                        String expression = (String)infoExpressions.get(e);
                        if (expressions.contains(expression)) continue;
                        expressions.add(expression);
                    }
                }
            }
            return expressions;
        }

        @Override
        protected void addDataItems() {
            if (this.frame != null) {
                List<String> expressions;
                if (!this.createNewExpressions && this.lastExpressions != null) {
                    expressions = this.lastExpressions;
                } else {
                    expressions = this.getExpressions(this.debuggingProcess);
                    this.lastExpressions = expressions;
                    this.createNewExpressions = false;
                }
                int size = expressions.size();
                if (size > 0) {
                    if (SmartWindow.this.smartWindowSettings.isSortExpressions()) {
                        Collections.sort(expressions);
                    }
                    List root = this.getRoot();
                    for (int i = 0; i < size; ++i) {
                        String s = expressions.get(i);
                        EvaluatorItem ei = new EvaluatorItem(s);
                        this.addDataItem(root, ei, true, true);
                    }
                }
            }
        }
    }
}

